/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.client.DynamicTooltip;
import aztech.modern_industrialization.network.pipes.SetItemWhitelistPacket;
import aztech.modern_industrialization.pipes.gui.PipeGuiHelper;
import aztech.modern_industrialization.pipes.gui.PipeScreen;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ItemPipeScreen
extends PipeScreen<ItemPipeScreenHandler> {
    private static final ResourceLocation TEXTURE = MI.id("textures/gui/pipe/item.png");
    private static final Style SECONDARY_INFO = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(true));

    public ItemPipeScreen(ItemPipeScreenHandler handler, Inventory inventory, Component title) {
        super(handler, inventory, title, 196);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new WhitelistButton(this.leftPos, this.topPos, widget -> {
            boolean newWhitelist = !((ItemPipeScreenHandler)this.menu).pipeInterface.isWhitelist();
            ((ItemPipeScreenHandler)this.menu).pipeInterface.setWhitelist(newWhitelist);
            new SetItemWhitelistPacket(((ItemPipeScreenHandler)this.menu).containerId, newWhitelist).sendToServer();
        }, () -> {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            if (((ItemPipeScreenHandler)this.menu).pipeInterface.isWhitelist()) {
                lines.add(MIText.Whitelist.text());
                lines.add(MIText.ClickToToggleBlacklist.text().setStyle(SECONDARY_INFO));
            } else {
                lines.add(MIText.Blacklist.text());
                lines.add(MIText.ClickToToggleWhitelist.text().setStyle(SECONDARY_INFO));
            }
            return lines;
        }));
        this.addConnectionTypeButton(148, 22, ((ItemPipeScreenHandler)this.menu).pipeInterface);
        this.addPriorityWidgets(35, 72, ((ItemPipeScreenHandler)this.menu).pipeInterface, 0, this.makePriorityWidgetTooltip(0, true), () -> ((ItemPipeScreenHandler)this.menu).pipeInterface.getConnectionType() != 2);
        this.addPriorityWidgets(35, 86, ((ItemPipeScreenHandler)this.menu).pipeInterface, 1, this.makePriorityWidgetTooltip(1, false), () -> ((ItemPipeScreenHandler)this.menu).pipeInterface.getConnectionType() != 0);
    }

    private Supplier<List<Component>> makePriorityWidgetTooltip(int channel, boolean insert) {
        return () -> {
            ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
            MIText priorityText = insert ? MIText.PriorityInsert : MIText.PriorityExtract;
            lines.add(priorityText.text(((ItemPipeScreenHandler)this.menu).pipeInterface.getPriority(channel)));
            if (insert && ((ItemPipeScreenHandler)this.menu).pipeInterface.getConnectionType() == 2) {
                lines.add(MIText.PriorityNotApplicable.text(MIText.PipeConnectionTooltipExtractOnly.text().setStyle(MITooltips.HIGHLIGHT_STYLE), MIText.PipeConnectionOut.text().setStyle(MITooltips.HIGHLIGHT_STYLE)).setStyle(TextHelper.GRAY_TEXT));
            } else if (!insert && ((ItemPipeScreenHandler)this.menu).pipeInterface.getConnectionType() == 0) {
                lines.add(MIText.PriorityNotApplicable.text(MIText.PipeConnectionTooltipInsertOnly.text().setStyle(MITooltips.HIGHLIGHT_STYLE), MIText.PipeConnectionIn.text().setStyle(MITooltips.HIGHLIGHT_STYLE)).setStyle(TextHelper.GRAY_TEXT));
            } else {
                lines.add(MIText.PriorityItemHelp.text(MIText.PipeConnectionOut.text().setStyle(MITooltips.HIGHLIGHT_STYLE), MIText.PipeConnectionIn.text().setStyle(MITooltips.HIGHLIGHT_STYLE)).setStyle(TextHelper.GRAY_TEXT));
            }
            return lines;
        };
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component title = this.title;
        if (((ItemPipeScreenHandler)this.menu).pipeInterface.isWhitelist() && ((ItemPipeScreenHandler)this.menu).pipeInterface.isFilterEmpty()) {
            title = title.copy().append((Component)Component.literal((String)" ")).append((Component)MIText.EmptyWhitelistWarning.text().setStyle(TextHelper.WARNING_TEXT));
        }
        guiGraphics.drawString(this.font, title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.hoveredSlot != null && this.hoveredSlot instanceof ItemPipeScreenHandler.UpgradeSlot && !this.hoveredSlot.hasItem()) {
            guiGraphics.renderTooltip(this.font, (Component)new MITooltips.Line(MIText.PutMotorToUpgrade).build(), x, y);
        }
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return TEXTURE;
    }

    private class WhitelistButton
    extends Button {
        private final Supplier<List<Component>> tooltipSupplier;

        public WhitelistButton(int i, int j, Button.OnPress onPress, Supplier<List<Component>> tooltipSupplier) {
            super(i + 148, j + 44, 20, 20, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
            this.tooltipSupplier = tooltipSupplier;
            this.setTooltip(new DynamicTooltip(tooltipSupplier));
        }

        public Component getMessage() {
            return this.tooltipSupplier.get().getFirst();
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
            int u = ((ItemPipeScreenHandler)((ItemPipeScreen)ItemPipeScreen.this).menu).pipeInterface.isWhitelist() ? 0 : 20;
            int v = this.isHoveredOrFocused() ? 20 : 0;
            RenderSystem.enableDepthTest();
            guiGraphics.blit(PipeGuiHelper.BUTTON_TEXTURE, this.getX(), this.getY(), u, v, this.width, this.height);
        }
    }
}

