/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.item;

import aztech.modern_industrialization.inventory.WhitelistedItemStorage;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.item.ExtractionSource;
import aztech.modern_industrialization.pipes.item.IItemSink;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class ItemNetwork
extends PipeNetwork {
    public static final int TICK_RATE = 60;
    private static final ReferenceOpenHashSet<Item> WHITELIST_CACHED_SET = new ReferenceOpenHashSet();
    int inactiveTicks = 0;
    long lastMovedItems = 0L;

    public ItemNetwork(int id, PipeNetworkData data) {
        super(id, data == null ? new ItemNetworkData() : data);
    }

    @Override
    public void tick(ServerLevel world) {
        if (this.inactiveTicks == 0) {
            this.doNetworkTransfer(world);
            this.inactiveTicks = 60;
        }
        --this.inactiveTicks;
    }

    private void doNetworkTransfer(ServerLevel world) {
        ArrayList<ExtractionSource> extractionSources = new ArrayList<ExtractionSource>();
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            BlockPos pos = entry.getPos();
            ItemNetworkNode itemNode = (ItemNetworkNode)entry.getNode();
            for (ItemNetworkNode.ItemConnection connection : itemNode.connections) {
                Direction querySide;
                BlockPos queryPos;
                IItemHandler source;
                if (!connection.canExtract() || (source = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, queryPos = pos.relative(connection.direction), (Object)(querySide = connection.direction.getOpposite()))) == null) continue;
                extractionSources.add(new ExtractionSource(connection, source, queryPos, querySide));
            }
        }
        extractionSources.sort(Comparator.comparing(et -> et.connection().extractPriority));
        List<Aggregate> insertTargets = this.getAggregatedInsertTargets(world);
        this.lastMovedItems = 0L;
        for (ExtractionSource target : extractionSources) {
            while (insertTargets.size() > 0 && target.connection().extractPriority > insertTargets.get(insertTargets.size() - 1).getPriority()) {
                insertTargets.remove(insertTargets.size() - 1);
            }
            try {
                this.lastMovedItems += (long)ItemNetwork.moveAll(world, target, insertTargets, target.connection()::canStackMoveThrough, target.connection().getMoves());
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.forThrowable((Throwable)exception, (String)"Moving items in a pipe network");
                crashReport.addCategory("Block being extracted from:").setDetail("Dimension", (Object)world.dimension()).setDetail("Position", (Object)target.queryPos()).setDetail("Accessed from side", (Object)target.querySide());
                throw new ReportedException(crashReport);
            }
        }
    }

    private static int moveAll(ServerLevel world, ExtractionSource target, List<? extends IItemSink> sinks, Predicate<ItemStack> filter, int maxToMove) {
        ItemStack stack;
        IItemHandler source = target.storage();
        int moved = 0;
        int sourceSlots = source.getSlots();
        for (int i = 0; i < sourceSlots && ((stack = source.getStackInSlot(i)).isEmpty() || !filter.test(stack) || (moved += IItemSink.listMoveAll(sinks, world, target, i, maxToMove - moved)) < maxToMove); ++i) {
        }
        return moved;
    }

    private List<Aggregate> getAggregatedInsertTargets(ServerLevel world) {
        Int2ObjectOpenHashMap priorityBuckets = new Int2ObjectOpenHashMap();
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ItemNetworkNode node = (ItemNetworkNode)entry.getNode();
            for (ItemNetworkNode.ItemConnection connection : node.connections) {
                WhitelistedItemStorage wis;
                IItemHandler target;
                if (!connection.canInsert()) continue;
                if (connection.cache == null) {
                    connection.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)world, (BlockPos)entry.getPos().relative(connection.direction), (Object)connection.direction.getOpposite());
                }
                if ((target = (IItemHandler)connection.cache.getCapability()) == null || target.getSlots() <= 0) continue;
                PriorityBucket bucket = (PriorityBucket)priorityBuckets.computeIfAbsent(connection.insertPriority, PriorityBucket::new);
                InsertTarget it = new InsertTarget(connection, new IItemSink.HandlerWrapper(target));
                if (connection.whitelist || target instanceof WhitelistedItemStorage && (wis = (WhitelistedItemStorage)target).currentlyWhitelisted()) {
                    bucket.whitelist.add(it);
                    continue;
                }
                bucket.blacklist.add(it);
            }
        }
        PriorityBucket[] sortedBuckets = (PriorityBucket[])priorityBuckets.values().toArray((Object[])new PriorityBucket[0]);
        Arrays.sort(sortedBuckets, Comparator.comparingInt(pb -> -pb.priority));
        ArrayList<Aggregate> targets = new ArrayList<Aggregate>();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (PriorityBucket pb2 : sortedBuckets) {
            int whitelistSize = pb2.whitelist.size();
            int blacklistSize = pb2.blacklist.size();
            if (whitelistSize > 0) {
                Collections.shuffle(pb2.whitelist);
                targets.add(new WhitelistAggregate(pb2.priority, pb2.whitelist));
            }
            if (blacklistSize > 0) {
                Collections.shuffle(pb2.blacklist);
                targets.add(new BlacklistAggregate(pb2.priority, pb2.blacklist));
            }
            if (whitelistSize <= 0 || blacklistSize <= 0 || !(((Random)random).nextDouble() >= (double)whitelistSize / (double)(whitelistSize + blacklistSize))) continue;
            Collections.swap(targets, targets.size() - 2, targets.size() - 1);
        }
        return targets;
    }

    private static int insertTargets(List<InsertTarget> targets, ServerLevel world, ExtractionSource source, int sourceSlot, int maxAmount) {
        int moved = 0;
        for (InsertTarget target : targets) {
            ItemStack stack = source.storage().getStackInSlot(sourceSlot);
            if (!stack.isEmpty() && (!target.connection.canStackMoveThrough(stack) || (moved += target.target.moveAll(world, source, sourceSlot, maxAmount - moved)) < maxAmount)) continue;
            break;
        }
        return moved;
    }

    private static interface Aggregate
    extends IItemSink {
        public int getPriority();
    }

    private static class PriorityBucket {
        private final int priority;
        private final List<InsertTarget> whitelist = new ArrayList<InsertTarget>();
        private final List<InsertTarget> blacklist = new ArrayList<InsertTarget>();

        private PriorityBucket(int priority) {
            this.priority = priority;
        }
    }

    private record InsertTarget(ItemNetworkNode.ItemConnection connection, IItemSink target) {
    }

    private static class WhitelistAggregate
    implements Aggregate {
        private final int priority;
        private final Map<Item, List<IItemSink>> map = new IdentityHashMap<Item, List<IItemSink>>();
        private final List<InsertTarget> targets;

        WhitelistAggregate(int priority, List<InsertTarget> targets) {
            this.priority = priority;
            this.targets = targets;
            for (InsertTarget target : targets) {
                if (target.connection.whitelist) {
                    ItemNetworkNode.ItemConnection conn = target.connection;
                    for (ItemStack stack : conn.stacks) {
                        if (!stack.isComponentsPatchEmpty()) continue;
                        this.map.computeIfAbsent(stack.getItem(), v -> new ArrayList()).add(target.target);
                    }
                    continue;
                }
                IItemSink iItemSink = target.target;
                if (iItemSink instanceof WhitelistedItemStorage) {
                    WhitelistedItemStorage wis = (WhitelistedItemStorage)((Object)iItemSink);
                    WHITELIST_CACHED_SET.clear();
                    wis.getWhitelistedItems((Set<Item>)WHITELIST_CACHED_SET);
                    for (Item item : WHITELIST_CACHED_SET) {
                        this.map.computeIfAbsent(item, v -> new ArrayList()).add(target.target);
                    }
                    continue;
                }
                throw new IllegalStateException("Internal item pipe error! Should never happen!");
            }
        }

        @Override
        public int moveAll(ServerLevel world, ExtractionSource source, int sourceSlot, int maxAmount) {
            ItemStack stack = source.storage().getStackInSlot(sourceSlot);
            if (!stack.isComponentsPatchEmpty()) {
                return ItemNetwork.insertTargets(this.targets, world, source, sourceSlot, maxAmount);
            }
            List<IItemSink> targets = this.map.get(stack.getItem());
            if (targets != null) {
                return IItemSink.listMoveAll(targets, world, source, sourceSlot, maxAmount);
            }
            return 0;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }

    private static class BlacklistAggregate
    implements Aggregate {
        private final int priority;
        private final List<InsertTarget> targets;

        private BlacklistAggregate(int priority, List<InsertTarget> targets) {
            this.priority = priority;
            this.targets = targets;
        }

        @Override
        public int moveAll(ServerLevel world, ExtractionSource source, int sourceSlot, int maxAmount) {
            return ItemNetwork.insertTargets(this.targets, world, source, sourceSlot, maxAmount);
        }

        @Override
        public int getPriority() {
            return this.priority;
        }
    }
}

