/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.impl.PipePartBuilder;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeShapeBuilder
extends PipePartBuilder {
    private VoxelShape shape = Shapes.empty();

    PipeShapeBuilder(int slotPos, Direction direction) {
        super(slotPos, direction);
    }

    @Override
    protected void drawPipe(float length, PipePartBuilder.Intent intent, boolean end) {
        Vec3 up = this.up();
        this.addShape(this.pos.add(up.scale(0.0625)).add(this.right.scale(0.0625)), this.pos.subtract(up.scale(0.0625)).subtract(this.right.scale(0.0625)).add(this.facing.scale((double)length)));
    }

    private void addShape(Vec3 c1, Vec3 c2) {
        double x = Math.min(c1.x, c2.x);
        double y = Math.min(c1.y, c2.y);
        double z = Math.min(c1.z, c2.z);
        double X = Math.max(c1.x, c2.x);
        double Y = Math.max(c1.y, c2.y);
        double Z = Math.max(c1.z, c2.z);
        this.shape = Shapes.or((VoxelShape)this.shape, (VoxelShape)Shapes.box((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z));
    }

    VoxelShape getShape() {
        return this.shape;
    }

    public void centerConnector() {
        this.moveForward(-0.125f);
        this.drawPipe(0.125f, null);
    }
}

