/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.gui;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.client.screen.MIHandledScreen;
import aztech.modern_industrialization.network.pipes.IncrementPriorityPacket;
import aztech.modern_industrialization.network.pipes.SetConnectionTypePacket;
import aztech.modern_industrialization.pipes.gui.ConnectionTypeButton;
import aztech.modern_industrialization.pipes.gui.PriorityButton;
import aztech.modern_industrialization.pipes.gui.PriorityDisplay;
import aztech.modern_industrialization.pipes.gui.iface.ConnectionTypeInterface;
import aztech.modern_industrialization.pipes.gui.iface.PriorityInterface;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public abstract class PipeScreen<SH extends AbstractContainerMenu>
extends MIHandledScreen<SH> {
    public PipeScreen(SH handler, Inventory inventory, Component title, int backgroundHeight) {
        super(handler, inventory, title);
        this.imageHeight = backgroundHeight;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected abstract ResourceLocation getBackgroundTexture();

    protected void renderBg(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(this.getBackgroundTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void addPriorityWidgets(int startX, int startY, PriorityInterface priority, int channel, Supplier<List<Component>> tooltip, BooleanSupplier isEnabled) {
        this.addPriorityButton(startX, startY, 20, 12, "--", -10, priority, channel, tooltip, isEnabled);
        this.addPriorityButton(startX + 22, startY, 12, 0, "-", -1, priority, channel, tooltip, isEnabled);
        this.addPriorityButton(startX + 62, startY, 12, 0, "+", 1, priority, channel, tooltip, isEnabled);
        this.addPriorityButton(startX + 76, startY, 20, 12, "++", 10, priority, channel, tooltip, isEnabled);
        this.addRenderableWidget((GuiEventListener)new PriorityDisplay(startX + 34 + this.leftPos, startY + this.topPos, 28, 12, (Component)Component.literal((String)""), tooltip, () -> priority.getPriority(channel), this.font, isEnabled));
    }

    private void addPriorityButton(int x, int y, int width, int u, String text, int delta, PriorityInterface priority, int channel, Supplier<List<Component>> priorityTooltip, BooleanSupplier isEnabled) {
        this.addRenderableWidget((GuiEventListener)new PriorityButton(x + this.leftPos, y + this.topPos, width, u, text, button -> {
            priority.incrementPriority(channel, delta);
            new IncrementPriorityPacket(this.menu.containerId, channel, delta).sendToServer();
        }, priorityTooltip, isEnabled));
    }

    protected int connectionTypeForward(ConnectionTypeInterface connectionType) {
        return (connectionType.getConnectionType() + 1) % 3;
    }

    protected int connectionTypeBackward(ConnectionTypeInterface connectionType) {
        return (connectionType.getConnectionType() + 2) % 3;
    }

    protected int connectionTypeNext(ConnectionTypeInterface connectionType) {
        if (!PipeScreen.hasShiftDown()) {
            return this.connectionTypeForward(connectionType);
        }
        return this.connectionTypeBackward(connectionType);
    }

    protected static Component getConnectionTypeText(int connectionType) {
        return switch (connectionType) {
            case 0 -> MIText.PipeConnectionTooltipInsertOnly.text();
            case 1 -> MIText.PipeConnectionTooltipInsertOrExtract.text();
            case 2 -> MIText.PipeConnectionTooltipExtractOnly.text();
            default -> throw new IllegalArgumentException("Connection Type " + connectionType + " must be either 0, 1, 2");
        };
    }

    protected void addConnectionTypeButton(int x, int y, ConnectionTypeInterface connectionType) {
        this.addRenderableWidget((GuiEventListener)new ConnectionTypeButton(x + this.leftPos, y + this.topPos, widget -> {
            int newType = this.connectionTypeNext(connectionType);
            connectionType.setConnectionType(newType);
            new SetConnectionTypePacket(this.menu.containerId, newType).sendToServer();
        }, () -> {
            ArrayList<Object> lines = new ArrayList<Object>();
            Component component = PipeScreen.getConnectionTypeText(connectionType.getConnectionType());
            lines.add(component);
            lines.add(MIText.PipeConnectionHelp.text().setStyle(TextHelper.GRAY_TEXT));
            return lines;
        }, connectionType));
    }
}

