/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class NuclearComponentItem
extends Item
implements INuclearComponent<ItemVariant> {
    public final int maxTemperature;
    public final double heatConduction;
    public final INeutronBehaviour neutronBehaviour;

    public NuclearComponentItem(Item.Properties settings, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour) {
        super(settings);
        this.maxTemperature = maxTemperature;
        this.heatConduction = heatConduction;
        this.neutronBehaviour = neutronBehaviour;
    }

    public static ItemDefinition<NuclearComponentItem> of(String englishName, String id, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour) {
        return MIItem.item(englishName, id, settings -> new NuclearComponentItem(settings.stacksTo(1), maxTemperature, heatConduction, neutronBehaviour), SortOrder.ITEMS_OTHER);
    }

    @Override
    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    @Override
    public double getHeatConduction() {
        return this.heatConduction;
    }

    @Override
    public INeutronBehaviour getNeutronBehaviour() {
        return this.neutronBehaviour;
    }

    @Override
    public ItemVariant getVariant() {
        return ItemVariant.of((ItemLike)this);
    }
}

