/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NuclearAbsorbable
extends NuclearComponentItem {
    public final int desintegrationMax;

    public NuclearAbsorbable(Item.Properties settings, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        super(settings.component(MIComponents.REMAINING_DISINTEGRATIONS, (Object)desintegrationMax), maxTemperature, heatConduction, neutronBehaviour);
        this.desintegrationMax = desintegrationMax;
    }

    public void setRemainingDesintegrations(ItemStack stack, int value) {
        if (value < 0 || value > this.desintegrationMax) {
            throw new IllegalArgumentException(String.format("Remaining desintegration %d must be between 0 and max desintegration = %d", value, this.desintegrationMax));
        }
        stack.set(MIComponents.REMAINING_DISINTEGRATIONS, (Object)value);
    }

    public static ItemDefinition<NuclearComponentItem> of(String englishName, String id, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        return MIItem.item(englishName, id, settings -> new NuclearAbsorbable(settings.stacksTo(1), maxTemperature, heatConduction, neutronBehaviour, desintegrationMax), SortOrder.ITEMS_OTHER);
    }

    public double getDurabilityBarProgress(ItemStack stack) {
        return (double)this.getRemainingDesintegrations(stack) / (double)this.desintegrationMax;
    }

    public int getBarColor(ItemStack stack) {
        float f = (float)this.getRemainingDesintegrations(stack) / (float)this.desintegrationMax;
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getRemainingDesintegrations(stack) != this.desintegrationMax;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int getRemainingDesintegrations(ItemStack stack) {
        return (Integer)stack.getOrDefault(MIComponents.REMAINING_DISINTEGRATIONS, (Object)0);
    }

    protected static int randIntFromDouble(double value, RandomSource rand) {
        return (int)Math.floor(value) + (rand.nextDouble() < value % 1.0 ? 1 : 0);
    }

    public int simulateAbsorption(double neutronsReceived, ItemStack stack, RandomSource rand) {
        int absorbNeutrons = Math.min(NuclearAbsorbable.randIntFromDouble(neutronsReceived, rand), this.getRemainingDesintegrations(stack));
        this.setRemainingDesintegrations(stack, this.getRemainingDesintegrations(stack) - absorbNeutrons);
        return absorbNeutrons;
    }
}

