/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.misc.version;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIText;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Scanner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class VersionEvents {
    private static final String url = "https://api.cfwidget.com/minecraft/mc-mods/modern-industrialization";
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
    private static final String alphaPostfix = "alpha";

    private static Version fetchVersion(boolean isIncludeAlphaVersion) throws Exception {
        String mcVersion = ((ModContainer)ModList.get().getModContainerById("minecraft").get()).getModInfo().getVersion().toString();
        URLConnection connection = new URL(url).openConnection();
        try (Scanner scanner = new Scanner(connection.getInputStream());){
            PriorityQueue<Version> queue = new PriorityQueue<Version>();
            String response = scanner.useDelimiter("\\A").next();
            JsonObject jo = (JsonObject)JsonParser.parseString((String)response);
            for (JsonElement file : jo.getAsJsonArray("files")) {
                JsonObject fileAsJsonObject = file.getAsJsonObject();
                boolean matchesCurrentMcVersion = false;
                for (JsonElement version : fileAsJsonObject.get("versions").getAsJsonArray()) {
                    if (!version.getAsString().equals(mcVersion)) continue;
                    matchesCurrentMcVersion = true;
                }
                if (!matchesCurrentMcVersion) continue;
                String name = fileAsJsonObject.get("display").getAsString();
                String url = fileAsJsonObject.get("url").getAsString();
                String type = fileAsJsonObject.get("type").getAsString();
                String date = fileAsJsonObject.get("uploaded_at").getAsString();
                if (!isIncludeAlphaVersion && type.equals(alphaPostfix)) continue;
                queue.add(new Version(name, url, format.parse(date)));
            }
            if (!queue.isEmpty()) {
                Version version = (Version)queue.poll();
                return version;
            }
        }
        return null;
    }

    public static void startVersionCheck(ModContainer miContainer, LocalPlayer player) {
        new Thread(() -> {
            try {
                String lastVersionString;
                String currentVersion;
                Version lastVersion;
                if (MIConfig.getConfig().newVersionMessage && (lastVersion = VersionEvents.fetchVersion((currentVersion = miContainer.getModInfo().getVersion().toString()).contains(alphaPostfix))) != null && !(lastVersionString = lastVersion.name.replaceFirst("Modern Industrialization v", "").strip()).equals(currentVersion)) {
                    String url = lastVersion.url;
                    Style styleClick = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).applyFormat(ChatFormatting.UNDERLINE).applyFormat(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)MIText.ClickUrl.text()));
                    Minecraft.getInstance().execute(() -> {
                        if (Minecraft.getInstance().player == player) {
                            player.displayClientMessage((Component)MIText.NewVersion.text(lastVersionString, MIText.CurseForge.text().setStyle(styleClick)), false);
                        }
                    });
                }
            }
            catch (Exception e) {
                MI.LOGGER.error("Failed to get release information from Curseforge.", (Throwable)e);
            }
        }, "Modern Industrialization Update Checker").start();
    }

    public static void init(ModContainer miContainer) {
        NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, event -> VersionEvents.startVersionCheck(miContainer, event.getPlayer()));
    }

    private record Version(String name, String url, Date date) implements Comparable<Version>
    {
        @Override
        public int compareTo(@NotNull Version o) {
            return o.date.compareTo(this.date);
        }
    }
}

