/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.PartKey;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeOutput;

public class Material {
    public final String name;
    final Map<PartKey, MaterialItemPart> parts;
    private final Map<MaterialProperty<?>, Object> properties;
    public final Consumer<RecipeOutput> registerRecipes;

    Material(String name, Map<MaterialProperty<?>, Object> properties, Map<PartKey, MaterialItemPart> parts, Consumer<RecipeOutput> registerRecipes) {
        this.name = name;
        this.properties = properties;
        this.parts = parts;
        this.registerRecipes = registerRecipes;
    }

    public Map<PartKey, MaterialItemPart> getParts() {
        return Collections.unmodifiableMap(this.parts);
    }

    public MaterialItemPart getPart(PartKeyProvider part) {
        MaterialItemPart ret = this.parts.get(part.key());
        if (ret == null) {
            throw new IllegalArgumentException("Can't find part " + String.valueOf(part) + " in material " + this.name);
        }
        return ret;
    }

    public <T> T get(MaterialProperty<T> prop) {
        return (T)this.properties.get(prop);
    }
}

