/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class CustomProcessCondition
implements MachineProcessCondition {
    static final Map<String, Definition> definitions = new HashMap<String, Definition>();
    static final MapCodec<CustomProcessCondition> CODEC = Codec.STRING.fieldOf("custom_id").xmap(CustomProcessCondition::new, c -> c.id);
    static final StreamCodec<RegistryFriendlyByteBuf, CustomProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, c -> c.id, (StreamCodec)ComponentSerialization.TRUSTED_STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.description, CustomProcessCondition::new);
    private final String id;
    private final List<Component> description;

    public static void onReload() {
        definitions.clear();
        KubeJSProxy.instance.fireCustomConditionEvent();
    }

    public static void register(String id, BiPredicate<MachineProcessCondition.Context, MachineRecipe> predicate, Component ... description) {
        Objects.requireNonNull(predicate);
        if (definitions.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate custom process condition definition: " + id);
        }
        if (description.length == 0) {
            throw new IllegalArgumentException("Custom process condition must have a description");
        }
        definitions.put(id, new Definition(predicate, List.of(description)));
    }

    private static MapCodec<CustomProcessCondition> makeCodec(boolean syncToClient) {
        return RecordCodecBuilder.mapCodec(g -> g.group((App)Codec.STRING.fieldOf("custom_id").forGetter(c -> c.id), (App)ComponentSerialization.CODEC.listOf().optionalFieldOf("description").forGetter(c -> syncToClient ? Optional.of(c.description) : Optional.empty())).apply((Applicative)g, (id, desc) -> desc.map(d -> new CustomProcessCondition((String)id, (List<Component>)d)).orElseGet(() -> new CustomProcessCondition((String)id))));
    }

    public CustomProcessCondition(String id) {
        Definition definition = definitions.get(id);
        if (definition == null) {
            throw new IllegalArgumentException("Unknown custom process condition definition: " + id);
        }
        this.id = id;
        this.description = definition.description;
    }

    public CustomProcessCondition(String id, List<Component> description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        return CustomProcessCondition.definitions.get((Object)this.id).predicate.test(context, recipe);
    }

    @Override
    public void appendDescription(List<Component> list) {
        list.addAll(this.description);
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }

    private record Definition(BiPredicate<MachineProcessCondition.Context, MachineRecipe> predicate, List<Component> description) {
    }
}

