/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.recipe.condition;

import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record BiomeProcessCondition(ResourceKey<Biome> biome) implements MachineProcessCondition
{
    static final MapCodec<BiomeProcessCondition> CODEC = ResourceKey.codec((ResourceKey)Registries.BIOME).fieldOf("biome").xmap(BiomeProcessCondition::new, BiomeProcessCondition::biome);
    static final StreamCodec<RegistryFriendlyByteBuf, BiomeProcessCondition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.BIOME), BiomeProcessCondition::biome, BiomeProcessCondition::new);

    @Override
    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        Holder entityBiome = context.getLevel().getBiome(context.getBlockEntity().getBlockPos());
        return entityBiome.is(this.biome);
    }

    @Override
    public void appendDescription(List<Component> list) {
        ResourceLocation loc = this.biome.location();
        MutableComponent biomeComponent = Component.translatable((String)"biome.%s.%s".formatted(loc.getNamespace(), loc.getPath()));
        list.add((Component)MIText.RequiresBiome.text(biomeComponent));
    }

    @Override
    public MapCodec<? extends MachineProcessCondition> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ? extends MachineProcessCondition> streamCodec() {
        return STREAM_CODEC;
    }
}

