/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.machine.component.FluidAccess;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.bridge.SlotFluidHandler;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.base.SingleVariantStorage;
import com.google.common.base.Preconditions;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidStorageComponent
implements IComponent,
FluidAccess {
    private long capacity;
    SingleVariantStorage<FluidVariant> singleStorageVariant = new SingleVariantStorage<FluidVariant>(){

        @Override
        protected FluidVariant getBlankVariant() {
            return FluidVariant.blank();
        }

        @Override
        protected long getCapacity(FluidVariant variant) {
            return FluidStorageComponent.this.capacity;
        }
    };
    private final IFluidHandler fluidHandler = new SlotFluidHandler(this.singleStorageVariant);

    public SingleVariantStorage<FluidVariant> getFluidStorage() {
        return this.singleStorageVariant;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        Preconditions.checkArgument((capacity >= 0L ? 1 : 0) != 0, (Object)"Fluid Capacity must be > 0");
        this.capacity = capacity;
        this.singleStorageVariant.amount = Math.min(this.singleStorageVariant.amount, capacity);
    }

    public FluidVariant getFluid() {
        return (FluidVariant)this.singleStorageVariant.variant;
    }

    @Override
    public long getAmount() {
        return this.singleStorageVariant.amount;
    }

    @Override
    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("fluid", ((FluidVariant)this.singleStorageVariant.variant).toNbt(registries));
        tag.putLong("amount", this.singleStorageVariant.amount);
        tag.putLong("capacity", this.capacity);
    }

    @Override
    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        this.singleStorageVariant.variant = FluidVariant.fromNbt(tag.getCompound("fluid"), registries);
        this.singleStorageVariant.amount = tag.getLong("amount");
        this.capacity = tag.getLong("capacity");
    }

    @Override
    public FluidVariant getVariant() {
        return this.getFluid();
    }
}

