/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.machine.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractElectricCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.OverdriveComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.machines.guicomponents.ShapeSelection;
import aztech.modern_industrialization.machines.guicomponents.SlotPanel;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class DistillationTowerBlockEntity
extends AbstractElectricCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private static final int MAX_HEIGHT = MIConfig.getConfig().maxDistillationTowerHeight;
    private static final ShapeTemplate[] shapeTemplates = new ShapeTemplate[MAX_HEIGHT];
    private final UpgradeComponent upgrades = new UpgradeComponent();
    private final OverdriveComponent overdrive = new OverdriveComponent();

    public DistillationTowerBlockEntity(BEP bep) {
        super(bep, "distillation_tower", new OrientationComponent.Params(false, false, false), shapeTemplates);
        this.registerComponents(this.upgrades, this.overdrive);
        this.registerGuiComponent(new SlotPanel.Server(this).withRedstoneControl(this.redstoneControl).withUpgrades(this.upgrades).withOverdrive(this.overdrive));
        GuiComponent.Server[] serverArray = new GuiComponent.Server[1];
        ShapeSelection.LineInfo[] lineInfoArray = new ShapeSelection.LineInfo[1];
        lineInfoArray[0] = new ShapeSelection.LineInfo(MAX_HEIGHT, IntStream.range(1, MAX_HEIGHT + 1).mapToObj(xva$0 -> MIText.ShapeTextHeight.text(xva$0)).toList(), false);
        serverArray[0] = new ShapeSelection.Server(new ShapeSelection.Behavior(){

            @Override
            public void handleClick(int clickedLine, int delta) {
                DistillationTowerBlockEntity.this.activeShape.incrementShape(DistillationTowerBlockEntity.this, delta);
            }

            @Override
            public int getCurrentIndex(int line) {
                return DistillationTowerBlockEntity.this.activeShape.getActiveShapeIndex();
            }
        }, lineInfoArray);
        this.registerGuiComponent(serverArray);
    }

    @Override
    public MachineRecipeType recipeType() {
        return MIMachineRecipeTypes.DISTILLATION_TOWER;
    }

    @Override
    public long getBaseRecipeEu() {
        return MachineTier.MULTIBLOCK.getBaseEu();
    }

    @Override
    public long getMaxRecipeEu() {
        return (long)MachineTier.MULTIBLOCK.getMaxEu() + this.upgrades.getAddMaxEUPerTick();
    }

    @Override
    public boolean isOverdriving() {
        return this.overdrive.shouldOverdrive();
    }

    @Override
    public int getMaxFluidOutputs() {
        return this.activeShape.getActiveShapeIndex() + 1;
    }

    public static void registerReiShapes() {
        for (int i = 0; i < shapeTemplates.length; ++i) {
            ReiMachineRecipes.registerMultiblockShape("distillation_tower", shapeTemplates[i], "" + i);
        }
    }

    static {
        SimpleMember casing = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("clean_stainless_steel_machine_casing")));
        SimpleMember pipe = SimpleMember.forBlock((Supplier)MIBlock.BLOCK_DEFINITIONS.get(MI.id("stainless_steel_machine_casing_pipe")));
        HatchFlags bottom = new HatchFlags.Builder().with(HatchType.ENERGY_INPUT, HatchType.FLUID_INPUT).build();
        HatchFlags layer = new HatchFlags.Builder().with(HatchType.FLUID_OUTPUT).build();
        for (int i = 0; i < MAX_HEIGHT; ++i) {
            ShapeTemplate.Builder builder = new ShapeTemplate.Builder(MachineCasings.CLEAN_STAINLESS_STEEL);
            for (int y = 0; y <= i + 1; ++y) {
                builder.add3by3(y, casing, y != 0, y == 0 ? bottom : layer);
                if (y == 0) continue;
                builder.add(0, y, 1, pipe, null);
            }
            DistillationTowerBlockEntity.shapeTemplates[i] = builder.build();
        }
    }
}

