/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.items.armor.QuantumArmorItem;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class MIArmorEffects {
    private MIArmorEffects() {
    }

    public static boolean quantumArmorPreventsDamage(LivingEntity entity) {
        int parts = 0;
        for (QuantumArmorItem item : QuantumArmorItem.ITEMS) {
            if (entity.getItemBySlot(item.getType().getSlot()).getItem() != item) continue;
            ++parts;
        }
        return ThreadLocalRandom.current().nextDouble() < (double)parts / 4.0;
    }

    public static boolean canTankFlyIntoWall(ItemStack helmet) {
        return helmet.getItem() == MIItem.RUBBER_HELMET.asItem() || helmet.getItem() == MIItem.QUANTUM_HELMET.asItem();
    }

    public static boolean canTankFall(ItemStack boots) {
        return boots.getItem() == MIItem.RUBBER_BOOTS.asItem() || boots.getItem() == MIItem.QUANTUM_BOOTS.asItem();
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(LivingIncomingDamageEvent.class, event -> {
            if (MIArmorEffects.quantumArmorPreventsDamage(event.getEntity())) {
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(LivingIncomingDamageEvent.class, event -> {
            ItemStack head;
            LivingEntity entity = event.getEntity();
            DamageSource source = event.getContainer().getSource();
            float amount = event.getContainer().getOriginalDamage();
            ItemStack tankingStack = null;
            EquipmentSlot es = null;
            if (source.is(DamageTypes.FLY_INTO_WALL)) {
                es = EquipmentSlot.HEAD;
                head = entity.getItemBySlot(es);
                if (MIArmorEffects.canTankFlyIntoWall(head)) {
                    tankingStack = head;
                }
            } else if (source.is(DamageTypes.FALL) && MIArmorEffects.canTankFall(head = entity.getItemBySlot(es = EquipmentSlot.FEET))) {
                tankingStack = head;
            }
            if (tankingStack != null) {
                int intAmount = (int)Math.ceil(amount);
                tankingStack.hurtAndBreak(intAmount, entity, es);
                event.setCanceled(true);
            }
        });
    }
}

