/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.armor;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.items.ActivatableItem;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;

public class GraviChestPlateItem
extends ArmorItem
implements ActivatableItem,
ISimpleEnergyItem {
    public static final long FLIGHT_COST = 1024L;
    public static final long ENERGY_CAPACITY = 0x1000000L;

    public GraviChestPlateItem(Item.Properties settings) {
        super(MIArmorMaterials.GRAVICHESTPLATE, ArmorItem.Type.CHESTPLATE, settings.stacksTo(1).rarity(Rarity.EPIC).component(MIComponents.ACTIVATED.get(), (Object)false));
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        if (this.getStoredEnergy(stack) > 0L && this.isActivated(stack)) {
            return ItemAttributeModifiers.builder().add(NeoForgeMod.CREATIVE_FLIGHT, new AttributeModifier(MI.id("gravichestplate_flight"), 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.CHEST).build().withTooltip(false);
        }
        return ItemAttributeModifiers.EMPTY;
    }

    public DataComponentType<Long> getEnergyComponent() {
        return MIComponents.ENERGY.get();
    }

    public long getEnergy(ItemStack stack) {
        return this.getStoredEnergy(stack);
    }

    public void setEnergy(ItemStack stack, long energy) {
        this.setStoredEnergy(stack, energy);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (level.isClientSide()) {
            return;
        }
        if (entity instanceof Player && stack == (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST) && player.getAbilities().flying) {
            this.setEnergy(stack, Math.max(0L, this.getEnergy(stack) - 1024L));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        return (int)Math.round((double)this.getEnergy(stack) / 1.6777216E7 * 13.0);
    }

    public long getEnergyCapacity(ItemStack stack) {
        return 0x1000000L;
    }

    public long getEnergyMaxInput(ItemStack stack) {
        return 0x1000000L;
    }

    public long getEnergyMaxOutput(ItemStack stack) {
        return 0L;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)("item.modifiers." + this.getType().getSlot().getName())).withStyle(ChatFormatting.GRAY));
        list.add((Component)MIText.AllowCreativeFlight.text().withStyle(ChatFormatting.BLUE));
    }
}

