/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.tag;

import appeng.api.features.P2PTunnelAttunement;
import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.compat.ae2.MIAEAddon;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.machines.blockentities.ReplicatorMachineBlockEntity;
import aztech.modern_industrialization.materials.MIMaterials;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class MIItemTagProvider
extends ItemTagsProvider {
    private final boolean runtimeDatagen;

    public MIItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper, boolean runtimeDatagen) {
        super(output, lookupProvider, CompletableFuture.completedFuture(TagsProvider.TagLookup.empty()), "modern_industrialization", existingFileHelper);
        this.runtimeDatagen = runtimeDatagen;
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (Map.Entry<TagKey<Item>, List<ItemLike>> entry : TagsToGenerate.tagToItemMap.entrySet()) {
            boolean optional = TagsToGenerate.optionalTags.contains(entry.getKey());
            List<Item> items = entry.getValue().stream().map(ItemLike::asItem).sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0))).toList();
            for (Item item : items) {
                if (optional) {
                    this.tag(entry.getKey()).addOptional(BuiltInRegistries.ITEM.getKey((Object)item));
                    continue;
                }
                this.tag(entry.getKey()).add((Object)item);
            }
        }
        for (Map.Entry<Object, Collection<Object>> entry : TagsToGenerate.tagToBeAddedToAnotherTag.entrySet()) {
            ResourceLocation tagId = ResourceLocation.parse((String)((String)entry.getKey()));
            for (String tag : (Set)entry.getValue()) {
                this.tag(MIItemTagProvider.key(tagId)).addTag(MIItemTagProvider.key(tag));
            }
        }
        for (MaterialItemPart materialItemPart : MIMaterials.GOLD.getParts().values()) {
            String namespace = materialItemPart.getItemId().split(":")[0];
            if (Objects.equals(namespace, "minecraft")) continue;
            this.tag(ItemTags.PIGLIN_LOVED).add((Object)materialItemPart.asItem());
        }
        this.tag(ReplicatorMachineBlockEntity.BLACKLISTED).add((Object[])new Item[]{Items.BUNDLE, MIItem.PORTABLE_STORAGE_UNIT.asItem()}).addTag(Tags.Items.SHULKER_BOXES).addTag(MITags.TANKS).addTag(MITags.BARRELS);
        this.tag(Tags.Items.TOOLS_SHEAR).add((Object)MIItem.DIESEL_CHAINSAW.asItem());
        this.tag(MITags.WRENCHES).add((Object)MIItem.WRENCH.asItem());
        this.tag(ItemTags.AXES).add((Object)MIItem.DIESEL_CHAINSAW.asItem());
        this.tag(ItemTags.HOES).add((Object)MIItem.DIESEL_CHAINSAW.asItem());
        this.tag(ItemTags.PICKAXES).add((Object[])new Item[]{MIItem.STEAM_MINING_DRILL.asItem(), MIItem.DIESEL_MINING_DRILL.asItem()});
        this.tag(ItemTags.SHOVELS).add((Object[])new Item[]{MIItem.STEAM_MINING_DRILL.asItem(), MIItem.DIESEL_MINING_DRILL.asItem()});
        this.tag(ItemTags.SWORDS).add((Object)MIItem.DIESEL_CHAINSAW.asItem());
        this.tag(ItemTags.COALS).add(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)MI.id("lignite_coal")));
        if (ModList.get().isLoaded("ae2") && !this.runtimeDatagen) {
            this.tag(P2PTunnelAttunement.getAttunementTag(MIAEAddon.ENERGY_P2P_TUNNEL)).add((Object)MIMaterials.SUPERCONDUCTOR.getPart(MIParts.CABLE).asItem());
        }
    }

    private static TagKey<Item> key(ResourceLocation id) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)id);
    }

    private static TagKey<Item> key(String id) {
        return MIItemTagProvider.key(ResourceLocation.parse((String)id));
    }
}

