/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.guicomponents.EnergyBarClient;
import aztech.modern_industrialization.machines.guicomponents.ProgressBarClient;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.RecipeConversions;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;

public class MachineCategory
extends ViewerCategory<RecipeHolder<MachineRecipe>> {
    private final MachineCategoryParams params;

    public static MachineCategory create(MachineCategoryParams params) {
        int x = 1000;
        int X = 0;
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions : new SlotPositions[]{params.itemInputs, params.itemOutputs, params.fluidInputs, params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                x = Math.min(x, positions.getX(i));
                X = Math.max(X, positions.getX(i) + 16);
                y = Math.min(y, positions.getY(i));
                Y = Math.max(Y, positions.getY(i) + 16);
            }
        }
        int width = Math.max(X - x + 15, 120);
        int height = Y - y + 25;
        return new MachineCategory(params, width, height);
    }

    private MachineCategory(MachineCategoryParams params, int width, int height) {
        super(RecipeHolder.class, params.category, (Component)Component.translatable((String)"rei_categories.%s.%s".formatted(params.category.getNamespace(), params.category.getPath())), ((Item)BuiltInRegistries.ITEM.get(params.workstations.get(0))).getDefaultInstance(), width, height);
        this.params = params;
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        for (ResourceLocation workstation : this.params.workstations) {
            consumer.accept((ItemLike)BuiltInRegistries.ITEM.get(workstation));
        }
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<RecipeHolder<MachineRecipe>> consumer) {
        List<RecipeHolder> machineRecipes = recipeManager.getRecipes().stream().filter(r -> r.value() instanceof MachineRecipe).map(r -> r).toList();
        machineRecipes.stream().filter(r -> this.params.recipePredicate.test((MachineRecipe)r.value())).sorted(Comparator.comparing(RecipeHolder::id)).forEach(consumer);
        if (this.params.category.getNamespace().equals("modern_industrialization")) {
            switch (this.params.category.getPath()) {
                case "bronze_furnace": {
                    recipeManager.getAllRecipesFor(RecipeType.SMELTING).stream().map(r -> RecipeConversions.ofSmelting((RecipeHolder<SmeltingRecipe>)r, MIMachineRecipeTypes.FURNACE, registryAccess)).forEach(consumer);
                    break;
                }
                case "bronze_cutting_machine": {
                    recipeManager.getAllRecipesFor(RecipeType.STONECUTTING).stream().map(r -> RecipeConversions.ofStonecutting((RecipeHolder<StonecutterRecipe>)r, MIMachineRecipeTypes.CUTTING_MACHINE, registryAccess)).forEach(consumer);
                    break;
                }
                case "centrifuge": {
                    ComposterBlock.COMPOSTABLES.keySet().stream().map(RecipeConversions::ofCompostable).filter(Objects::nonNull).forEach(consumer);
                }
            }
        }
    }

    @Override
    public void buildLayout(RecipeHolder<MachineRecipe> recipe, ViewerCategory.LayoutBuilder builder) {
        this.addItemInputs(builder, (MachineRecipe)recipe.value());
        this.addItemOutputs(builder, (MachineRecipe)recipe.value());
        this.addFluidInputs(builder, (MachineRecipe)recipe.value());
        this.addFluidOutputs(builder, (MachineRecipe)recipe.value());
    }

    private void addItemInputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.itemInputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.inputSlot(x, y);
            if (i >= recipe.itemInputs.size()) continue;
            MachineRecipe.ItemInput input = recipe.itemInputs.get(i);
            slot.ingredient(input.ingredient(), input.amount(), input.probability());
        }
    }

    private void addItemOutputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.itemOutputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.outputSlot(x, y);
            if (i >= recipe.itemOutputs.size()) continue;
            MachineRecipe.ItemOutput output = recipe.itemOutputs.get(i);
            slot.item(output.getStack(), output.probability());
        }
    }

    private void addFluidInputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.fluidInputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.inputSlot(x, y);
            if (i < recipe.fluidInputs.size()) {
                MachineRecipe.FluidInput input = recipe.fluidInputs.get(i);
                slot.fluid(FluidVariant.of(input.fluid()), input.amount(), input.probability());
                continue;
            }
            slot.variant(FluidVariant.blank());
        }
    }

    private void addFluidOutputs(ViewerCategory.LayoutBuilder builder, MachineRecipe recipe) {
        DrawOffset offset = this.getOffset();
        SlotPositions positions = this.params.fluidOutputs;
        for (int i = 0; i < positions.size(); ++i) {
            int x = offset.x + positions.getX(i);
            int y = offset.y + positions.getY(i);
            ViewerCategory.SlotBuilder slot = builder.outputSlot(x, y);
            if (i < recipe.fluidOutputs.size()) {
                MachineRecipe.FluidOutput output = recipe.fluidOutputs.get(i);
                slot.fluid(FluidVariant.of(output.fluid()), output.amount(), output.probability());
                continue;
            }
            slot.variant(FluidVariant.blank());
        }
    }

    @Override
    public void buildWidgets(RecipeHolder<MachineRecipe> recipeHolder, ViewerCategory.WidgetList widgets) {
        boolean conditionsRequired;
        DrawOffset offset = this.getOffset();
        MachineRecipe recipe = (MachineRecipe)recipeHolder.value();
        double recipeMillis = this.getSeconds(recipe) * 1000.0;
        widgets.drawable(matrices -> ProgressBarClient.renderProgress(matrices, offset.x, offset.y, this.params.progressBarParams, (float)((double)System.currentTimeMillis() / recipeMillis % 1.0)));
        widgets.drawable(guiGraphics -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(5.0f, 5.0f, 0.0f);
            guiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            switch (this.params.steamMode) {
                case BOTH: {
                    guiGraphics.blit(MachineScreen.SLOT_ATLAS, -2, -2, 80, 18, 20, 20);
                    break;
                }
                case STEAM_ONLY: {
                    guiGraphics.blit(MI.id("textures/item/steam_bucket.png"), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                    break;
                }
                case ELECTRIC_ONLY: {
                    EnergyBarClient.Renderer.renderEnergy(guiGraphics, 0, 0, 1.0f);
                }
            }
            guiGraphics.pose().popPose();
        });
        widgets.text((Component)TextHelper.getEuTextTick(recipe.eu), 15 + (this.params.steamMode.steam ? 2 : 0), 5.0f, ViewerCategory.TextAlign.LEFT, false, true, null);
        widgets.text((Component)MIText.BaseDurationSeconds.text(this.getSeconds(recipe)), this.width - 5, 5.0f, ViewerCategory.TextAlign.RIGHT, false, true, null);
        boolean steelHatchRequired = this.params.steamMode.steam && this.params.isMultiblock && recipe.eu > MachineTier.BRONZE.getMaxEu();
        int upgradeEuRequired = recipe.eu - (this.params.isMultiblock ? MachineTier.MULTIBLOCK : MachineTier.LV).getMaxEu();
        if (upgradeEuRequired > 0 && this.id.getPath().equals("fusion_reactor")) {
            upgradeEuRequired = 0;
        }
        boolean bl = conditionsRequired = recipe.conditions.size() > 0;
        if (steelHatchRequired || upgradeEuRequired > 0 || conditionsRequired) {
            Object displayedItem = steelHatchRequired ? (ItemLike)BuiltInRegistries.ITEM.get(MI.id("steel_item_input_hatch")) : (conditionsRequired ? MIItem.WRENCH : MIItem.BASIC_UPGRADE);
            widgets.item((float)this.width / 2.0f - 3.0f, 3.75, 10.8, 10.8, (ItemLike)displayedItem);
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)MIText.BaseEuTotal.text(TextHelper.getEuText((long)recipe.duration * (long)recipe.eu)));
        if (this.params.steamMode.steam) {
            tooltips.add((Component)(this.params.steamMode.electric ? MIText.AcceptsSteamToo : MIText.AcceptsSteam).text().withStyle(ChatFormatting.GRAY));
            if (steelHatchRequired) {
                tooltips.add((Component)MIText.RequiresSteelHatch0.text().setStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
                tooltips.add((Component)MIText.RequiresSteelHatch1.text().withStyle(ChatFormatting.GRAY));
            }
        }
        if (upgradeEuRequired > 0) {
            tooltips.add((Component)new MITooltips.Line(MIText.RequiresUpgrades).arg(upgradeEuRequired, MITooltips.EU_PER_TICK_PARSER).build());
        }
        if (conditionsRequired) {
            for (MachineProcessCondition condition : recipe.conditions) {
                condition.appendDescription(tooltips);
            }
        }
        widgets.tooltip(2, 5, this.width - 10, 11, tooltips);
    }

    private double getSeconds(MachineRecipe recipe) {
        return (double)recipe.duration / 20.0;
    }

    private DrawOffset getOffset() {
        int x = 1000;
        int X = 0;
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions : new SlotPositions[]{this.params.itemInputs, this.params.itemOutputs, this.params.fluidInputs, this.params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                x = Math.min(x, positions.getX(i));
                X = Math.max(X, positions.getX(i) + 16);
                y = Math.min(y, positions.getY(i));
                Y = Math.max(Y, positions.getY(i) + 16);
            }
        }
        int xoffset = (this.width - X + x) / 2 - x;
        int yoffset = 17 - y;
        return new DrawOffset(xoffset, yoffset);
    }

    @Override
    public ResourceLocation getRecipeId(RecipeHolder<MachineRecipe> recipe) {
        return recipe.id();
    }

    private record DrawOffset(int x, int y) {
    }
}

