/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.kubejs.recipe;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.compat.kubejs.recipe.MachineRecipeSchema;
import aztech.modern_industrialization.compat.kubejs.recipe.ProcessConditionHelper;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.item.ItemVariant;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class MachineKubeRecipe
extends KubeRecipe
implements ProcessConditionHelper {
    public static final KubeRecipeFactory FACTORY = new KubeRecipeFactory(MI.id("machine"), MachineKubeRecipe.class, MachineKubeRecipe::new);

    private <T> MachineKubeRecipe addToList(RecipeKey<List<T>> key, T element) {
        List value = (List)this.getValue(key);
        ArrayList<T> list = value == null ? new ArrayList<T>() : new ArrayList(value);
        list.add(element);
        this.setValue(key, list);
        return this;
    }

    public MachineKubeRecipe itemIn(SizedIngredient ingredient) {
        return this.itemIn(ingredient, 1.0f);
    }

    public MachineKubeRecipe itemIn(SizedIngredient ingredient, float chance) {
        return this.addToList(MachineRecipeSchema.ITEM_INPUTS, new MachineRecipe.ItemInput(ingredient.ingredient(), ingredient.count(), chance));
    }

    public MachineKubeRecipe itemOut(ItemStack output) {
        return this.itemOut(output, 1.0f);
    }

    public MachineKubeRecipe itemOut(ItemStack output, float chance) {
        return this.addToList(MachineRecipeSchema.ITEM_OUTPUTS, new MachineRecipe.ItemOutput(ItemVariant.of(output), output.getCount(), chance));
    }

    public MachineKubeRecipe fluidIn(Fluid fluid, long mbs) {
        return this.fluidIn(fluid, mbs, 1.0f);
    }

    public MachineKubeRecipe fluidIn(Fluid fluid, long mbs, float probability) {
        return this.addToList(MachineRecipeSchema.FLUID_INPUTS, new MachineRecipe.FluidInput(fluid, mbs, probability));
    }

    public MachineKubeRecipe fluidOut(Fluid fluid, long mbs) {
        return this.fluidOut(fluid, mbs, 1.0f);
    }

    public MachineKubeRecipe fluidOut(Fluid fluid, long mbs, float probability) {
        return this.addToList(MachineRecipeSchema.FLUID_OUTPUTS, new MachineRecipe.FluidOutput(fluid, mbs, probability));
    }

    @Override
    public MachineKubeRecipe processCondition(MachineProcessCondition condition) {
        return this.addToList(MachineRecipeSchema.MACHINE_PROCESS_CONDITIONS, condition);
    }
}

