/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.blocks.storage.tank.AbstractTankBlockEntity;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;

public class TankRenderer
implements BlockEntityRenderer<AbstractTankBlockEntity> {
    private final int lockIconColor;

    public TankRenderer(int lockIconColor) {
        this.lockIconColor = lockIconColor;
    }

    public void render(AbstractTankBlockEntity tank, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (!((FluidVariant)tank.getResource()).isBlank()) {
            if (tank.behaviour.isCreative()) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), 1.0f);
            } else if (tank.getAmount() > 0L) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), (float)tank.getAmount() / (float)tank.getCapacity());
            } else if (tank.isLocked()) {
                RenderHelper.drawFluidInTank(tank, matrices, vertexConsumers, (FluidVariant)tank.getResource(), 0.01f);
            }
        }
        if (tank.isLocked()) {
            RenderHelper.drawLockedTexture(tank, matrices, vertexConsumers, this.lockIconColor);
        }
    }
}

