/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockItem;
import aztech.modern_industrialization.blocks.storage.ResourceStorage;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.util.FluidHelper;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TankItem
extends AbstractStorageBlockItem<FluidVariant> {
    public TankItem(TankBlock block, Item.Properties settings) {
        super(block, settings);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (this.behaviour.isCreative()) {
            tooltip.add(FluidHelper.getFluidName((FluidVariant)this.getResource(stack), true));
        } else {
            long capacity = this.behaviour.getCapacityForResource((FluidVariant)this.getResource(stack));
            if (this.isEmpty(stack)) {
                if (!this.isUnlocked(stack)) {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage((FluidVariant)this.getResource(stack), 0L, capacity));
                } else {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage(FluidVariant.blank(), 0L, capacity));
                }
            } else {
                tooltip.addAll(FluidHelper.getTooltipForFluidStorage((FluidVariant)this.getResource(stack), this.getAmount(stack), capacity));
            }
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }

    @Override
    public DataComponentType<ResourceStorage<FluidVariant>> getComponentType() {
        return MIComponents.FLUID_STORAGE.get();
    }

    @Override
    public ResourceStorage<FluidVariant> getDefaultComponent() {
        return ResourceStorage.FLUID_EMPTY;
    }
}

