/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.MIBlockKeys;
import aztech.modern_industrialization.compat.kubejs.KubeJSProxy;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StoragePreconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CableTier
implements Comparable<CableTier> {
    public static CableTier LV = new CableTier("lv", "LV", "Low Voltage", 32L, null);
    public static CableTier MV = new CableTier("mv", "MV", "Medium Voltage", 128L, MIBlockKeys.ADVANCED_MACHINE_HULL);
    public static CableTier HV = new CableTier("hv", "HV", "High Voltage", 1024L, MIBlockKeys.TURBO_MACHINE_HULL);
    public static CableTier EV = new CableTier("ev", "EV", "Extreme Voltage", 8192L, MIBlockKeys.HIGHLY_ADVANCED_MACHINE_HULL);
    public static CableTier SUPERCONDUCTOR = new CableTier("superconductor", "Superconductor", "Superconductor", 128000000L, MIBlockKeys.QUANTUM_MACHINE_HULL);
    public final String name;
    public final String shortEnglishName;
    public final String longEnglishName;
    public final long eu;
    @Nullable
    public final ResourceLocation itemKey;
    public final boolean builtin;
    @ApiStatus.Internal
    public final MachineCasing casing;
    private static final Map<String, CableTier> tiers = new HashMap<String, CableTier>();

    @ApiStatus.Internal
    public CableTier(String name, String shortEnglishName, String longEnglishName, long eu, ResourceLocation itemKey, boolean builtin) {
        StoragePreconditions.notNegative(eu);
        this.name = name;
        this.shortEnglishName = shortEnglishName;
        this.longEnglishName = longEnglishName;
        this.eu = eu;
        this.itemKey = itemKey;
        this.casing = MachineCasings.create(name);
        this.builtin = builtin;
    }

    private CableTier(String name, String shortEnglishName, String longEnglishName, long eu, @Nullable ResourceKey<Block> key) {
        this(name, shortEnglishName, longEnglishName, eu, key == null ? null : key.location(), true);
    }

    public String shortEnglishKey() {
        return "cable_tier_short.modern_industrialization." + this.name;
    }

    public MutableComponent shortEnglishName() {
        return Component.translatable((String)this.shortEnglishKey());
    }

    public String longEnglishKey() {
        return "cable_tier_long.modern_industrialization." + this.name;
    }

    public MutableComponent longEnglishName() {
        return Component.translatable((String)this.longEnglishKey());
    }

    public long getMaxTransfer() {
        return this.eu * 8L;
    }

    public long getEu() {
        return this.eu;
    }

    @Override
    public int compareTo(@NotNull CableTier other) {
        return Long.compare(this.eu, other.eu);
    }

    public String toString() {
        return this.name;
    }

    @ApiStatus.Internal
    public static void addTier(CableTier tier) {
        for (CableTier existingTier : tiers.values()) {
            if (existingTier.name.equals(tier.name)) {
                throw new IllegalArgumentException("Tier " + String.valueOf(tier) + " already exists!");
            }
            if (existingTier.eu == tier.eu) {
                throw new IllegalArgumentException("A tier with eu " + tier.eu + " already exists!");
            }
            if (!Objects.equals(existingTier.itemKey, tier.itemKey)) continue;
            throw new IllegalArgumentException("A tier with block key " + String.valueOf(tier.itemKey) + " already exists!");
        }
        tiers.put(tier.name, tier);
    }

    public static CableTier getTier(String name) {
        CableTier existing = tiers.get(name);
        if (existing == null) {
            throw new NoSuchElementException("No such cable tier: " + name);
        }
        return existing;
    }

    public static List<CableTier> allTiers() {
        return tiers.values().stream().sorted().toList();
    }

    static {
        CableTier.addTier(LV);
        CableTier.addTier(MV);
        CableTier.addTier(HV);
        CableTier.addTier(EV);
        CableTier.addTier(SUPERCONDUCTOR);
        KubeJSProxy.instance.fireCableTiersEvent();
    }
}

