/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.datamaps.ItemPipeUpgrade;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.items.PortableStorageUnit;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.items.diesel_tools.DieselToolItem;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.components.CasingComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.proxy.CommonProxy;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.base.Preconditions;
import dev.technici4n.grandpower.api.ILongEnergyStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class MITooltips {
    public static final PriorityQueue<TooltipAttachment> TOOLTIPS = new PriorityQueue();
    public static final Style DEFAULT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(false));
    public static final Style HIGHLIGHT_STYLE;
    public static final Style NUMBER_TEXT;
    private static final Map<Class<?>, Style> DEFAULT_ARGUMENT_STYLE;
    public static final Parser<Object> DEFAULT_PARSER;
    public static final Parser<Number> EU_PER_TICK_PARSER;
    public static final Parser<Number> EU_PARSER;
    public static final Parser<NumberWithMax> EU_MAXED_PARSER;
    public static final Parser<Fluid> FLUID_PARSER;
    public static final Parser<Double> RATIO_PERCENTAGE_PARSER;
    public static final Parser<Double> INVERTED_RATIO_PERCENTAGE_PARSER;
    public static final Parser<BlockState> BLOCK_STATE_PARSER;
    public static final Parser<Item> ITEM_PARSER;
    public static final Parser<String> KEYBIND_PARSER;
    public static final Parser<Component> COMPONENT;
    public static final TooltipAttachment BATTERIES;
    public static final TooltipAttachment CABLES;
    public static final TooltipAttachment COILS;
    public static final TooltipAttachment ENERGY_STORED_ITEM;
    public static final TooltipAttachment LUBRICANT_BUCKET;
    public static final TooltipAttachment GUNPOWDER;
    public static final TooltipAttachment MACHINE_TOOLTIPS;
    public static final TooltipAttachment NUCLEAR;
    public static final TooltipAttachment ORES;
    public static final TooltipAttachment REDSTONE_CONTROL_MODULE;
    public static final TooltipAttachment OVERDRIVE_MODULE;
    public static final TooltipAttachment SPEED_UPGRADES;
    public static final TooltipAttachment UPGRADES;
    public static final TooltipAttachment STEAM_DRILL;
    public static final TooltipAttachment DIESEL_TOOLS;
    public static final TooltipAttachment CONFIG_CARD_HELP;
    public static final TooltipAttachment MACHINE_CASING_VOLTAGE;
    public static final TooltipAttachment PIPE_HELP;
    public static final Map<String, String> TOOLTIPS_ENGLISH_TRANSLATION;

    public static int colorFromProgress(double progress, boolean zeroIsGreen) {
        progress = Math.max(0.0, Math.min(1.0, progress));
        if (!zeroIsGreen) {
            progress = 1.0 - progress;
        }
        double r = Math.min(2.0 * progress, 1.0);
        double g = Math.min(1.0, 2.0 - 2.0 * progress);
        return (int)(r * 255.0) << 16 | (int)(g * 255.0) << 8;
    }

    public static Style styleFromProgress(double progress, boolean zeroIsGreen) {
        return Style.EMPTY.withColor(TextColor.fromRgb((int)MITooltips.colorFromProgress(progress, zeroIsGreen))).withItalic(Boolean.valueOf(false));
    }

    public static void attachTooltip(ItemStack stack, List<Component> lines) {
        block3: {
            Item item = stack.getItem();
            if (item == null) break block3;
            boolean hasPrintRequiredShift = false;
            for (TooltipAttachment tooltip : TOOLTIPS) {
                Optional<List<? extends Component>> maybeComponents;
                block5: {
                    block4: {
                        maybeComponents = tooltip.tooltipLines.apply(stack, stack.getItem());
                        if (!tooltip.requiresShift) break block4;
                        if (!CommonProxy.INSTANCE.hasShiftDown()) break block5;
                    }
                    maybeComponents.ifPresent(lines::addAll);
                    continue;
                }
                if (!tooltip.requiresShift || hasPrintRequiredShift || !maybeComponents.isPresent()) continue;
                lines.add((Component)MIText.TooltipsShiftRequired.text().setStyle(DEFAULT_STYLE));
                hasPrintRequiredShift = true;
            }
        }
    }

    private static void add(Predicate<ItemLike> attachTo, String translationId, String ... englishTooltipsLine) {
        int lineCount = englishTooltipsLine.length;
        Preconditions.checkArgument((lineCount > 0 ? 1 : 0) != 0);
        String[] translationKey = (String[])IntStream.range(0, lineCount).mapToObj(l -> "item_tooltip.modern_industrialization." + translationId + ".line_" + l).toArray(String[]::new);
        for (int i = 0; i < lineCount; ++i) {
            TOOLTIPS_ENGLISH_TRANSLATION.put(translationKey[i], englishTooltipsLine[i]);
        }
        TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (attachTo.test((ItemLike)item)) {
                return Optional.of(Arrays.stream(translationKey).map(key -> Component.translatable((String)key).withStyle(DEFAULT_STYLE)).collect(Collectors.toList()));
            }
            return Optional.empty();
        });
    }

    private static void add(ItemLike itemLike, String ... englishTooltipsLine) {
        MITooltips.add((ItemLike item) -> itemLike.asItem() == item, BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath(), englishTooltipsLine);
    }

    private static void add(String itemId, String ... englishTooltipsLine) {
        MITooltips.add((ItemLike)BuiltInRegistries.ITEM.get(MI.id(itemId)), englishTooltipsLine);
    }

    public static Line line(MIText baseText) {
        return new Line(baseText);
    }

    public static Line line(MIText baseText, Style style) {
        return new Line(baseText, style);
    }

    static {
        NUMBER_TEXT = HIGHLIGHT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)16768637)).withItalic(Boolean.valueOf(false));
        DEFAULT_ARGUMENT_STYLE = new HashMap();
        DEFAULT_ARGUMENT_STYLE.put(Integer.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Long.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Float.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Double.class, NUMBER_TEXT);
        DEFAULT_PARSER = new Parser<Object>(){

            @Override
            public Component parse(Object o) {
                Style style = DEFAULT_STYLE;
                for (Map.Entry<Class<?>, Style> entry : DEFAULT_ARGUMENT_STYLE.entrySet()) {
                    if (!o.getClass().isAssignableFrom(entry.getKey())) continue;
                    style = entry.getValue();
                    break;
                }
                if (o instanceof Fluid) {
                    Fluid f = (Fluid)o;
                    return FLUID_PARSER.parse(f);
                }
                if (o instanceof FluidLike) {
                    FluidLike f = (FluidLike)o;
                    return FLUID_PARSER.parse(f.asFluid());
                }
                if (o instanceof Item) {
                    return ITEM_PARSER.parse((Item)o);
                }
                if (o instanceof ItemLike) {
                    return ITEM_PARSER.parse(((ItemLike)o).asItem());
                }
                if (o instanceof Component) {
                    Component c = (Component)o;
                    return c.copy().withStyle(style);
                }
                return Component.literal((String)String.valueOf(o)).withStyle(style);
            }
        };
        EU_PER_TICK_PARSER = new Parser<Number>(){

            @Override
            public Component parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.EuT.text(amount.digit(), amount.unit()).withStyle(NUMBER_TEXT);
            }
        };
        EU_PARSER = new Parser<Number>(){

            @Override
            public Component parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.Eu.text(amount.digit(), amount.unit()).withStyle(NUMBER_TEXT);
            }
        };
        EU_MAXED_PARSER = new Parser<NumberWithMax>(){

            @Override
            public Component parse(NumberWithMax numberWithMax) {
                MutableComponent component = TextHelper.getEuTextMaxed(numberWithMax.number, numberWithMax.max);
                return component.withStyle(NUMBER_TEXT);
            }
        };
        FLUID_PARSER = new Parser<Fluid>(){

            @Override
            public Component parse(Fluid fluid) {
                return fluid.getFluidType().getDescription();
            }
        };
        RATIO_PERCENTAGE_PARSER = new Parser<Double>(){

            @Override
            public Component parse(Double ratio) {
                String percentage = String.format("%.1f", ratio * 100.0);
                return Component.literal((String)(percentage + "%")).withStyle(MITooltips.styleFromProgress(ratio, false));
            }
        };
        INVERTED_RATIO_PERCENTAGE_PARSER = new Parser<Double>(){

            @Override
            public Component parse(Double ratio) {
                String percentage = String.format("%.1f", ratio * 100.0);
                return Component.literal((String)(percentage + "%")).withStyle(MITooltips.styleFromProgress(ratio, true));
            }
        };
        BLOCK_STATE_PARSER = state -> state.getBlock().getName().withStyle(NUMBER_TEXT);
        ITEM_PARSER = state -> state.getDefaultInstance().getHoverName().copy().withStyle(NUMBER_TEXT);
        KEYBIND_PARSER = keybind -> Component.keybind((String)"key.%s".formatted(keybind)).withStyle(NUMBER_TEXT);
        COMPONENT = state -> state;
        BATTERIES = TooltipAttachment.of((itemStack, item) -> {
            if (PortableStorageUnit.CAPACITY_PER_BATTERY.containsKey(item)) {
                Long capacity = PortableStorageUnit.CAPACITY_PER_BATTERY.get((Object)itemStack.getItem());
                return Optional.of(new Line(MIText.BatteryInStorageUnit).arg(capacity, EU_PARSER).build());
            }
            return Optional.empty();
        });
        CABLES = TooltipAttachment.of((itemStack, item) -> {
            if (item instanceof PipeItem) {
                PipeItem pipe = (PipeItem)((Object)item);
                if (MIPipes.ELECTRICITY_PIPE_TIER.containsKey(pipe.type)) {
                    CableTier tier = MIPipes.ELECTRICITY_PIPE_TIER.get(pipe.type);
                    return Optional.of(new Line(MIText.EuCable).arg(tier.shortEnglishName()).arg(tier.getMaxTransfer(), EU_PER_TICK_PARSER).build());
                }
            }
            return Optional.empty();
        });
        COILS = TooltipAttachment.of((itemStack, item) -> {
            BlockItem blockItem;
            if (item instanceof BlockItem && ElectricBlastFurnaceBlockEntity.tiersByCoil.containsKey(BuiltInRegistries.BLOCK.getKey((Object)(blockItem = (BlockItem)item).getBlock()))) {
                long eu = ElectricBlastFurnaceBlockEntity.tiersByCoil.get(BuiltInRegistries.BLOCK.getKey((Object)((BlockItem)itemStack.getItem()).getBlock())).maxBaseEu();
                return Optional.of(new Line(MIText.EbfMaxEu).arg(eu).build());
            }
            return Optional.empty();
        });
        ENERGY_STORED_ITEM = TooltipAttachment.of((itemStack, item) -> {
            long capacity;
            ILongEnergyStorage energyStorage;
            if (BuiltInRegistries.ITEM.getKey(item).getNamespace().equals("modern_industrialization") && (energyStorage = (ILongEnergyStorage)itemStack.getCapability(EnergyApi.ITEM)) != null && (capacity = energyStorage.getCapacity()) > 0L) {
                return Optional.of(new Line(MIText.EnergyStored).arg(new NumberWithMax(energyStorage.getAmount(), capacity), EU_MAXED_PARSER).build());
            }
            return Optional.empty();
        }).noShiftRequired();
        LUBRICANT_BUCKET = TooltipAttachment.of((ItemLike)MIFluids.LUBRICANT.getBucket(), new Line(MIText.LubricantTooltip).arg("use", KEYBIND_PARSER).arg(25));
        GUNPOWDER = TooltipAttachment.of((ItemLike)Items.GUNPOWDER, MIText.GunpowderUpgrade);
        MACHINE_TOOLTIPS = TooltipAttachment.ofMultilines((itemStack, item) -> {
            MachineBlock machineBlock;
            BlockItem blockItem;
            Block patt0$temp;
            if (item instanceof BlockItem && (patt0$temp = (blockItem = (BlockItem)item).getBlock()) instanceof MachineBlock && !(machineBlock = (MachineBlock)patt0$temp).getBlockEntityInstance().getTooltips().isEmpty()) {
                return Optional.of(((MachineBlock)((BlockItem)itemStack.getItem()).getBlock()).getBlockEntityInstance().getTooltips());
            }
            return Optional.empty();
        });
        NUCLEAR = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (item instanceof NuclearAbsorbable) {
                LinkedList<MutableComponent> tooltips = new LinkedList<MutableComponent>();
                long remAbs = ((NuclearAbsorbable)itemStack.getItem()).getRemainingDesintegrations((ItemStack)itemStack);
                tooltips.add(new Line(MIText.RemAbsorption).arg(remAbs).arg(((NuclearAbsorbable)itemStack.getItem()).desintegrationMax).build());
                Item patt0$temp = itemStack.getItem();
                if (patt0$temp instanceof NuclearFuel) {
                    NuclearFuel fuel = (NuclearFuel)patt0$temp;
                    long totalEu = (long)fuel.totalEUbyDesintegration * (long)fuel.desintegrationMax;
                    tooltips.add(new Line(MIText.BaseEuTotalStored).arg(totalEu, EU_PARSER).build());
                }
                return Optional.of(tooltips);
            }
            return Optional.empty();
        });
        ORES = TooltipAttachment.ofMultilines((itemStack, item) -> {
            BlockItem blockItem;
            if (item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof OreBlock) {
                OreBlock oreBlock = (OreBlock)((BlockItem)itemStack.getItem()).getBlock();
                LinkedList<MutableComponent> lines = new LinkedList<MutableComponent>();
                MIConfig config = MIConfig.getConfig();
                if (config.enableDefaultOreGenTooltips) {
                    if (oreBlock.params.generate) {
                        lines.add(new Line(MIText.OreGenerationTooltipY).arg(-64).arg(oreBlock.params.maxYLevel).build());
                        lines.add(new Line(MIText.OreGenerationTooltipVeinFrequency).arg(oreBlock.params.veinsPerChunk).build());
                        lines.add(new Line(MIText.OreGenerationTooltipVeinSize).arg(oreBlock.params.veinSize).build());
                    } else {
                        lines.add(new Line(MIText.OreNotGenerated).build());
                    }
                    return Optional.of(lines);
                }
            }
            return Optional.empty();
        });
        REDSTONE_CONTROL_MODULE = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (MIItem.REDSTONE_CONTROL_MODULE.is((ItemStack)itemStack)) {
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                MIText requiredSignal = RedstoneControlModuleItem.isRequiresLowSignal(itemStack) ? MIText.SignalLow : MIText.SignalHigh;
                lines.add(MITooltips.line(MIText.RedstoneControlModuleHelp).build());
                lines.add(MITooltips.line(MIText.RedstoneControlModuleMachineRequires).arg(requiredSignal.text().setStyle(NUMBER_TEXT), COMPONENT).build());
                lines.add(MITooltips.line(MIText.UseItemToChange).arg("use", KEYBIND_PARSER).build());
                return Optional.of(lines);
            }
            return Optional.empty();
        });
        OVERDRIVE_MODULE = TooltipAttachment.of(MIItem.OVERDRIVE_MODULE, MIText.OverdriveModuleDescription);
        SPEED_UPGRADES = TooltipAttachment.ofMultilines((itemStack, item) -> {
            ItemPipeUpgrade upgrade = (ItemPipeUpgrade)itemStack.getItemHolder().getData(MIDataMaps.ITEM_PIPE_UPGRADES);
            if (upgrade != null) {
                LinkedList<MutableComponent> lines = new LinkedList<MutableComponent>();
                lines.add(new Line(MIText.TooltipSpeedUpgrade).arg(upgrade.maxExtractedItems()).build());
                if (itemStack.getCount() > 1) {
                    lines.add(new Line(MIText.TooltipSpeedUpgradeStack).arg(itemStack.getCount() * upgrade.maxExtractedItems()).build());
                }
                return Optional.of(lines);
            }
            return Optional.empty();
        });
        UPGRADES = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (UpgradeComponent.getExtraEu((ItemLike)item) > 0L) {
                LinkedList<MutableComponent> lines = new LinkedList<MutableComponent>();
                lines.add(new Line(MIText.MachineUpgrade).arg(UpgradeComponent.getExtraEu((ItemLike)itemStack.getItem()), EU_PER_TICK_PARSER).build());
                if (itemStack.getCount() > 1) {
                    lines.add(new Line(MIText.MachineUpgradeStack).arg((long)itemStack.getCount() * UpgradeComponent.getExtraEu((ItemLike)itemStack.getItem()), EU_PER_TICK_PARSER).build());
                }
                return Optional.of(lines);
            }
            return Optional.empty();
        });
        STEAM_DRILL = TooltipAttachment.ofMultilines(MIItem.STEAM_MINING_DRILL, List.of(MITooltips.line(MIText.ToolConfiguration).build(), MITooltips.line(MIText.SteamDrillWaterHelp).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.SteamDrillFuelHelp).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.SteamDrillProfit).arg("modern_industrialization.toggle_3x3", KEYBIND_PARSER).build(), MITooltips.line(MIText.SteamDrillToggle).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build()));
        DIESEL_TOOLS = TooltipAttachment.ofMultilines((itemStack, item) -> {
            if (item instanceof DieselToolItem) {
                DieselToolItem tool = (DieselToolItem)item;
                return Optional.of(List.of(MITooltips.line(MIText.ToolConfiguration).build(), MITooltips.line(MIText.DieselToolFuelHelp1).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.DieselToolFuelHelp2).build(), MITooltips.line(MIText.DieselToolToggle).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build()));
            }
            return Optional.empty();
        });
        CONFIG_CARD_HELP = TooltipAttachment.ofMultilines(MIItem.CONFIG_CARD, List.of(MITooltips.line(MIText.ConfigCardHelpCamouflage1).build(), MITooltips.line(MIText.ConfigCardHelpCamouflage2).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.ConfigCardHelpCamouflage3).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.ConfigCardHelpCamouflage4).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.ConfigCardHelpCamouflage5).arg("sneak", KEYBIND_PARSER).arg(MIText.KeyMouseScroll.text().withStyle(NUMBER_TEXT), COMPONENT).build(), Component.empty(), MITooltips.line(MIText.ConfigCardHelpItems1).build(), MITooltips.line(MIText.ConfigCardHelpItems2).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.ConfigCardHelpItems3).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.ConfigCardHelpClear).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build()));
        MACHINE_CASING_VOLTAGE = TooltipAttachment.of((itemStack, item) -> {
            CableTier tier = CasingComponent.getCasingTier(item);
            return tier == null ? Optional.empty() : Optional.of(new Line(MIText.MachineCasingVoltage).arg(Component.translatable((String)tier.shortEnglishKey())).build());
        });
        PIPE_HELP = TooltipAttachment.ofMultilines((itemStack, item) -> {
            PipeItem pipe;
            return item instanceof PipeItem && ((pipe = (PipeItem)((Object)item)).isItemPipe() || pipe.isFluidPipe()) ? Optional.of(List.of(MITooltips.line(MIText.PipeHelp1).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build(), MITooltips.line(MIText.PipeHelp2).arg("sneak", KEYBIND_PARSER).arg("use", KEYBIND_PARSER).build())) : Optional.empty();
        });
        TOOLTIPS_ENGLISH_TRANSLATION = new HashMap<String, String>();
        MITooltips.add(MIBlock.FORGE_HAMMER, "Use it to increase the yield of your ore blocks early game!", "(Use the Steam Mining Drill for an easy to get Silk Touch.)");
        MITooltips.add("stainless_steel_dust", "Use Slot-Locking with REI to differentiate its recipe from the invar dust");
        MITooltips.add("steam_blast_furnace", "Needs at least one Steel or higher tier hatch for 3 and 4 EU/t recipes");
        MITooltips.add(MIBlock.TRASH_CAN, "Will delete any item or fluid sent into it.", "Can also be used to empty a fluid slot by Right-Clicking on it with a Trash Can");
        MITooltips.add((ItemLike itemLike) -> {
            PipeItem pipe;
            Item patt0$temp = itemLike.asItem();
            return patt0$temp instanceof PipeItem && (pipe = (PipeItem)patt0$temp).isCable();
        }, "cable", " ", "Can power blocks from any mod, but can only extract energy from Modern Industrialization blocks and machines.", "They also are the only cables able to power Modern Industrialization machines.");
    }

    public static class TooltipAttachment
    implements Comparable<TooltipAttachment> {
        public final BiFunction<ItemStack, Item, Optional<List<? extends Component>>> tooltipLines;
        public boolean requiresShift = true;
        public int priority = 0;

        public static TooltipAttachment of(ItemLike itemLike, MIText text) {
            return TooltipAttachment.of(itemLike, new Line(text));
        }

        public static TooltipAttachment of(ItemLike itemLike, Line line) {
            return new TooltipAttachment((itemStack, item) -> itemStack.getItem() == itemLike.asItem() ? Optional.of(List.of(line.build())) : Optional.empty());
        }

        public static TooltipAttachment of(BiFunction<ItemStack, Item, Optional<? extends Component>> tooltipLines) {
            return new TooltipAttachment((itemStack, item) -> ((Optional)tooltipLines.apply((ItemStack)itemStack, (Item)item)).map(List::of));
        }

        public static TooltipAttachment ofMultilines(BiFunction<ItemStack, Item, Optional<List<? extends Component>>> tooltipLines) {
            return new TooltipAttachment(tooltipLines);
        }

        public static TooltipAttachment ofMultilines(ItemLike itemLike, List<? extends Component> tooltipLines) {
            return new TooltipAttachment((itemStack, item) -> {
                if (itemStack.getItem() == itemLike.asItem()) {
                    return Optional.of(tooltipLines);
                }
                return Optional.empty();
            });
        }

        public static TooltipAttachment ofMultilines(ItemLike itemLike, MIText ... tooltipLines) {
            return TooltipAttachment.ofMultilines(itemLike, Arrays.stream(tooltipLines).map(text -> text.text().withStyle(DEFAULT_STYLE)).collect(Collectors.toList()));
        }

        private TooltipAttachment(BiFunction<ItemStack, Item, Optional<List<? extends Component>>> tooltipLines) {
            this.tooltipLines = tooltipLines;
            TOOLTIPS.add(this);
        }

        public TooltipAttachment noShiftRequired() {
            this.requiresShift = false;
            return this;
        }

        public TooltipAttachment setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public int compareTo(@NotNull TooltipAttachment o) {
            return -Integer.compare(this.priority, o.priority);
        }
    }

    public static class Line {
        public final MIText baseText;
        public final Style baseStyle;
        public final List<Component> args = new LinkedList<Component>();

        public Line(MIText baseText, Style style) {
            this.baseText = baseText;
            this.baseStyle = style;
        }

        public Line(MIText baseText) {
            this(baseText, DEFAULT_STYLE);
        }

        public <T> Line arg(T arg, Parser<T> parser) {
            this.args.add(parser.parse(arg));
            return this;
        }

        public Line arg(Object arg) {
            this.arg(arg, DEFAULT_PARSER);
            return this;
        }

        public MutableComponent build() {
            return this.baseText.text(this.args.toArray()).withStyle(this.baseStyle);
        }
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public Component parse(T var1);
    }

    public record NumberWithMax(Number number, Number max) {
    }
}

