/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MICapabilities;
import aztech.modern_industrialization.MIComponents;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.ConfigCardItem;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.ForgeTool;
import aztech.modern_industrialization.items.GuideBookItem;
import aztech.modern_industrialization.items.PortableStorageUnit;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.items.SteamDrillItem;
import aztech.modern_industrialization.items.SteelUpgradeItem;
import aztech.modern_industrialization.items.armor.GraviChestPlateItem;
import aztech.modern_industrialization.items.armor.JetpackItem;
import aztech.modern_industrialization.items.armor.MIArmorMaterials;
import aztech.modern_industrialization.items.armor.QuantumArmorItem;
import aztech.modern_industrialization.items.diesel_tools.DieselToolItem;
import aztech.modern_industrialization.items.tools.QuantumSword;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import dev.technici4n.grandpower.api.ISimpleEnergyItem;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class MIItem {
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"modern_industrialization");
    public static final SortedMap<ResourceLocation, ItemDefinition<?>> ITEM_DEFINITIONS = new TreeMap();
    public static final ItemDefinition<GuideBookItem> GUIDE_BOOK = MIItem.item("MI Guidebook", "guidebook", GuideBookItem::new, SortOrder.GUIDE_BOOK);
    public static final ItemDefinition<ForgeTool> IRON_HAMMER = MIItem.itemHandheld("Iron Hammer", "iron_hammer", p -> new ForgeTool((Tier)Tiers.IRON, (Item.Properties)p), SortOrder.HAMMER);
    public static final ItemDefinition<ForgeTool> STEEL_HAMMER = MIItem.itemHandheld("Steel Hammer", "steel_hammer", p -> new ForgeTool(ForgeTool.STEEL, (Item.Properties)p), SortOrder.HAMMER);
    public static final ItemDefinition<ForgeTool> DIAMOND_HAMMER = MIItem.itemHandheld("Diamond Hammer", "diamond_hammer", p -> new ForgeTool((Tier)Tiers.DIAMOND, (Item.Properties)p), SortOrder.HAMMER);
    public static final ItemDefinition<ForgeTool> NETHERITE_HAMMER = MIItem.itemHandheld("Netherite Hammer", "netherite_hammer", p -> new ForgeTool((Tier)Tiers.NETHERITE, (Item.Properties)p), SortOrder.HAMMER);
    public static final ItemDefinition<Item> STEEL_UPGRADE = MIItem.item("Steel Upgrade", "steel_upgrade", SteelUpgradeItem::new, SortOrder.STEAM_TIER);
    public static final ItemDefinition<Item> RUBBER_SHEET = MIItem.item("Rubber Sheet", "rubber_sheet", SortOrder.STEAM_TIER);
    public static final ItemDefinition<Item> PACKER_BLOCK_TEMPLATE = MIItem.item("Packer Block Template", "packer_block_template", p -> new Item(p.rarity(Rarity.RARE).stacksTo(1)), SortOrder.STEAM_TIER);
    public static final ItemDefinition<Item> PACKER_DOUBLE_INGOT_TEMPLATE = MIItem.item("Packer Double Ingot Template", "packer_double_ingot_template", p -> new Item(p.rarity(Rarity.RARE).stacksTo(1)), SortOrder.STEAM_TIER);
    public static final ItemDefinition<Item> MOTOR = MIItem.item("Motor", "motor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> LARGE_MOTOR = MIItem.item("Large Motor", "large_motor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ADVANCED_MOTOR = MIItem.item("Advanced Motor", "advanced_motor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> LARGE_ADVANCED_MOTOR = MIItem.item("Large Advanced Motor", "large_advanced_motor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> PUMP = MIItem.item("Pump", "pump", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> LARGE_PUMP = MIItem.item("Large Pump", "large_pump", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ADVANCED_PUMP = MIItem.item("Advanced Pump", "advanced_pump", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> LARGE_ADVANCED_PUMP = MIItem.item("Large Advanced Pump", "large_advanced_pump", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> PISTON = MIItem.item("Piston", "piston", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> CONVEYOR = MIItem.item("Conveyor", "conveyor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ROBOT_ARM = MIItem.item("Robot Arm", "robot_arm", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> CIRCUIT_BOARD = MIItem.item("Analog Circuit Board", "analog_circuit_board", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ANALOG_CIRCUIT = MIItem.item("Analog Circuit", "analog_circuit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ELECTRONIC_CIRCUIT_BOARD = MIItem.item("Electronic Circuit Board", "electronic_circuit_board", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ELECTRONIC_CIRCUIT = MIItem.item("Electronic Circuit", "electronic_circuit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> PROCESSING_UNIT_BOARD = MIItem.item("Processing Unit Board", "processing_unit_board", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> PROCESSING_UNIT = MIItem.item("Processing Unit", "processing_unit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> DIGITAL_CIRCUIT_BOARD = MIItem.item("Digital Circuit Board", "digital_circuit_board", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> DIGITAL_CIRCUIT = MIItem.item("Digital Circuit", "digital_circuit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> QUANTUM_CIRCUIT_BOARD = MIItem.item("Quantum Circuit Board", "quantum_circuit_board", p -> new Item(p.rarity(Rarity.RARE)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> QUANTUM_CIRCUIT = MIItem.item("Quantum Circuit", "quantum_circuit", p -> new Item(p.rarity(Rarity.RARE)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> RESISTOR = MIItem.item("Resistor", "resistor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> CAPACITOR = MIItem.item("Capacitor", "capacitor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> INDUCTOR = MIItem.item("Inductor", "inductor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> WOOD_PULP = MIItem.item("Wood Pulp", "wood_pulp", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> INVAR_ROTARY_BLADE = MIItem.item("Invar Rotary Blade", "invar_rotary_blade", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> DIODE = MIItem.item("Diode", "diode", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> TRANSISTOR = MIItem.item("Transistor", "transistor", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> OP_AMP = MIItem.item("Op Amp", "op_amp", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> AND_GATE = MIItem.item("AND Gate", "and_gate", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> OR_GATE = MIItem.item("OR Gate", "or_gate", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> NOT_GATE = MIItem.item("NOT Gate", "not_gate", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> AIR_INTAKE = MIItem.item("Air Intake", "air_intake", p -> new Item(p.stacksTo(1)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> MONOCRYSTALLINE_SILICON = MIItem.item("Monocrystalline Silicon", "monocrystalline_silicon", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> SILICON_WAFER = MIItem.item("Silicon Wafer", "silicon_wafer", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ARITHMETIC_LOGIC_UNIT = MIItem.item("Arithmetic Logic Unit", "arithmetic_logic_unit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> MEMORY_MANAGEMENT_UNIT = MIItem.item("Memory Management Unit", "memory_management_unit", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> RANDOM_ACCESS_MEMORY = MIItem.item("Random Access Memory", "random_access_memory", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> QUBIT = MIItem.item("Qubit", "qubit", p -> new Item(p.rarity(Rarity.RARE)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> COOLING_CELL = MIItem.item("Cooling Cell", "cooling_cell", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ULTRADENSE_METAL_BALL = MIItem.item("Ultradense Metal Ball", "ultradense_metal_ball", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> SINGULARITY = MIItem.item("Singularity", "singularity", p -> new Item(p.rarity(Rarity.EPIC)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> BASIC_UPGRADE = MIItem.item("Basic Upgrade", "basic_upgrade", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> ADVANCED_UPGRADE = MIItem.item("Advanced Upgrade", "advanced_upgrade", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> TURBO_UPGRADE = MIItem.item("Turbo Upgrade", "turbo_upgrade", p -> new Item(p.rarity(Rarity.UNCOMMON)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> HIGHLY_ADVANCED_UPGRADE = MIItem.item("Highly Advanced Upgrade", "highly_advanced_upgrade", p -> new Item(p.rarity(Rarity.RARE)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> QUANTUM_UPGRADE = MIItem.item("Quantum Upgrade", "quantum_upgrade", p -> new Item(p.stacksTo(1).rarity(Rarity.RARE)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> REDSTONE_CONTROL_MODULE = MIItem.item("Redstone Control Module", "redstone_control_module", RedstoneControlModuleItem::new, (item, itemModelGenerators) -> {}, SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> OVERDRIVE_MODULE = MIItem.item("Overdrive Module", "overdrive_module", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> WRENCH = MIItem.itemNoModel("Wrench", "wrench", SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<SteamDrillItem> STEAM_MINING_DRILL = MIItem.itemHandheld("Steam Mining Drill", "steam_mining_drill", SteamDrillItem::new);
    public static final ItemDefinition<DieselToolItem> DIESEL_MINING_DRILL = MIItem.itemHandheld("Diesel Mining Drill", "diesel_mining_drill", s -> new DieselToolItem((Item.Properties)s, 7.0)).withItemRegistrationEvent(item -> MICapabilities.onEvent(event -> event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidFuelItemHelper.ItemStorage((ItemStack)stack, 4000), new ItemLike[]{item})));
    public static final ItemDefinition<DieselToolItem> DIESEL_CHAINSAW = MIItem.itemHandheld("Diesel Chainsaw", "diesel_chainsaw", p -> new DieselToolItem((Item.Properties)p, 12.0)).withItemRegistrationEvent(item -> MICapabilities.onEvent(event -> event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidFuelItemHelper.ItemStorage((ItemStack)stack, 4000), new ItemLike[]{item})));
    public static final ItemDefinition<PortableStorageUnit> PORTABLE_STORAGE_UNIT = MIItem.itemHandheld("Portable Storage Unit", "portable_storage_unit", PortableStorageUnit::new).withItemRegistrationEvent(item -> MICapabilities.onEvent(event -> event.registerItem(EnergyApi.ITEM, (stack, ctx) -> ISimpleEnergyItem.createStorage((ItemStack)stack, MIComponents.ENERGY.get(), (long)item.getEnergyCapacity((ItemStack)stack), (long)item.getEnergyMaxInput((ItemStack)stack), (long)item.getEnergyMaxOutput((ItemStack)stack)), new ItemLike[]{item})));
    public static final ItemDefinition<ArmorItem> RUBBER_HELMET = MIItem.item("Rubber Helmet", "rubber_helmet", s -> new ArmorItem(MIArmorMaterials.RUBBER, ArmorItem.Type.HELMET, s.stacksTo(1).durability(400)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<ArmorItem> RUBBER_BOOTS = MIItem.item("Rubber Boots", "rubber_boots", s -> new ArmorItem(MIArmorMaterials.RUBBER, ArmorItem.Type.BOOTS, s.stacksTo(1).durability(400)), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<JetpackItem> DIESEL_JETPACK = MIItem.item("Diesel Jetpack", "diesel_jetpack", JetpackItem::new, SortOrder.ITEMS_OTHER).withItemRegistrationEvent(item -> MICapabilities.onEvent(event -> event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> new FluidFuelItemHelper.ItemStorage((ItemStack)stack, 8000), new ItemLike[]{item})));
    public static final ItemDefinition<GraviChestPlateItem> GRAVICHESTPLATE = MIItem.item("Gravichestplate", "gravichestplate", GraviChestPlateItem::new, SortOrder.ITEMS_OTHER).withItemRegistrationEvent(item -> MICapabilities.onEvent(event -> event.registerItem(EnergyApi.ITEM, (stack, ctx) -> ISimpleEnergyItem.createStorage((ItemStack)stack, MIComponents.ENERGY.get(), (long)item.getEnergyCapacity((ItemStack)stack), (long)item.getEnergyMaxInput((ItemStack)stack), (long)item.getEnergyMaxOutput((ItemStack)stack)), new ItemLike[]{item})));
    public static final ItemDefinition<QuantumSword> QUANTUM_SWORD = MIItem.itemHandheld("Quantum Sword", "quantum_sword", QuantumSword::new);
    public static final ItemDefinition<QuantumArmorItem> QUANTUM_HELMET = MIItem.item("Quantum Helmet", "quantum_helmet", s -> new QuantumArmorItem(ArmorItem.Type.HELMET, (Item.Properties)s), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<QuantumArmorItem> QUANTUM_CHESTPLATE = MIItem.item("Quantum Chestplate", "quantum_chestplate", s -> new QuantumArmorItem(ArmorItem.Type.CHESTPLATE, (Item.Properties)s), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<QuantumArmorItem> QUANTUM_LEGGINGS = MIItem.item("Quantum Leggings", "quantum_leggings", s -> new QuantumArmorItem(ArmorItem.Type.LEGGINGS, (Item.Properties)s), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<QuantumArmorItem> QUANTUM_BOOTS = MIItem.item("Quantum Boots", "quantum_boots", s -> new QuantumArmorItem(ArmorItem.Type.BOOTS, (Item.Properties)s), SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<Item> UNCOOKED_STEEL_DUST = MIItem.item("Uncooked Steel Dust", "uncooked_steel_dust", SortOrder.MATERIALS.and((Comparable)((Object)"steel")));
    public static final ItemDefinition<Item> MIXED_INGOT_BLASTPROOF = MIItem.item("Mixed Blastproof Ingot", "mixed_ingot_blastproof", SortOrder.MATERIALS.and((Comparable)((Object)"blastproof")));
    public static final ItemDefinition<Item> MIXED_INGOT_IRIDIUM = MIItem.item("Mixed Iridium Ingot", "mixed_ingot_iridium", s -> new Item(s.food(new FoodProperties.Builder().nutrition(20).saturationModifier(1.0f).build())), SortOrder.MATERIALS.and((Comparable)((Object)"iridium")));
    public static final ItemDefinition<Item> MIXED_PLATE_NUCLEAR = MIItem.item("Nuclear Mixed Plate", "mixed_plate_nuclear", SortOrder.MATERIALS.and((Comparable)((Object)"nuclear")));
    public static final ItemDefinition<Item> WAX = MIItem.item("Wax", "wax", HoneycombItem::new, SortOrder.ITEMS_OTHER);
    public static final ItemDefinition<NuclearComponentItem> SMALL_HEAT_EXCHANGER = NuclearComponentItem.of("Small Heat Exchanger", "small_heat_exchanger", 2500, 0.15, INeutronBehaviour.NO_INTERACTION);
    public static final ItemDefinition<NuclearComponentItem> LARGE_HEAT_EXCHANGER = NuclearComponentItem.of("Large Heat Exchanger", "large_heat_exchanger", 1800, 0.3, INeutronBehaviour.NO_INTERACTION);
    public static final ItemDefinition<ConfigCardItem> CONFIG_CARD = MIItem.item("Pipe Config Card", "config_card", ConfigCardItem::new, SortOrder.PIPES);

    public static void init(IEventBus modBus) {
        ITEMS.register(modBus);
    }

    public static <T extends Item> ItemDefinition<T> item(String englishName, String path, Function<Item.Properties, T> ctor, BiConsumer<Item, ItemModelProvider> modelGenerator, SortOrder sortOrder) {
        DeferredItem holder = ITEMS.registerItem(path, ctor);
        ItemDefinition def = new ItemDefinition(englishName, holder, modelGenerator, sortOrder);
        ITEM_DEFINITIONS.put(holder.getId(), def);
        return def;
    }

    public static ItemDefinition<Item> item(String englishName, String path, SortOrder sortOrder) {
        return MIItem.item(englishName, path, Item::new, (item, modelGenerator) -> modelGenerator.basicItem(item), sortOrder);
    }

    public static <T extends Item> ItemDefinition<T> item(String englishName, String path, Function<Item.Properties, T> ctor, SortOrder sortOrder) {
        return MIItem.item(englishName, path, ctor, (item, modelGenerator) -> modelGenerator.basicItem(item), sortOrder);
    }

    public static ItemDefinition<Item> itemHandheld(String englishName, String path) {
        return MIItem.itemHandheld(englishName, path, Item::new);
    }

    public static ItemDefinition<Item> itemNoModel(String englishName, String path, SortOrder sortOrder) {
        return MIItem.item(englishName, path, Item::new, (item, modelGenerator) -> {}, sortOrder);
    }

    public static <T extends Item> ItemDefinition<T> itemNoModel(String englishName, String path, Function<Item.Properties, T> ctor, SortOrder sortOrder) {
        return MIItem.item(englishName, path, ctor, (item, modelGenerator) -> {}, sortOrder);
    }

    public static <T extends Item> ItemDefinition<T> itemHandheld(String englishName, String path, Function<Item.Properties, T> ctor) {
        return MIItem.itemHandheld(englishName, path, ctor, SortOrder.ITEMS_OTHER);
    }

    public static <T extends Item> ItemDefinition<T> itemHandheld(String englishName, String path, Function<Item.Properties, T> ctor, SortOrder sortOrder) {
        return MIItem.item(englishName, path, p -> (Item)ctor.apply(p.stacksTo(1)), (item, modelGenerator) -> modelGenerator.basicItem(item).parent((ModelFile)modelGenerator.getExistingFile(ResourceLocation.parse((String)"minecraft:item/handheld"))), sortOrder);
    }

    private MIItem() {
    }
}

