/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.logicprogrammer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.neoforge.NeoForgeTypes;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamicscompat.IntegratedDynamicsCompat;
import org.cyclops.integrateddynamicscompat.network.packet.CPacketSetSlot;

public class LogicProgrammerGhostIngredientHandler<T extends ContainerScreenLogicProgrammerBase<?>>
implements IGhostIngredientHandler<T> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T screen, ITypedIngredient<I> ingredientTyped, boolean doStart) {
        ArrayList targets = Lists.newArrayList();
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)screen.getMenu();
        ILogicProgrammerElement element = container.getActiveElement();
        if (element != null) {
            ItemStack itemStack = null;
            if (ingredientTyped.getType() == VanillaTypes.ITEM_STACK) {
                itemStack = (ItemStack)ingredientTyped.getItemStack().get();
            } else if (ingredientTyped.getType() == NeoForgeTypes.FLUID_STACK) {
                itemStack = new ItemStack((ItemLike)Items.BUCKET);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
                if (fluidHandler == null) {
                    throw new IllegalStateException("Could not find a fluid handler on the bucket item, some mod must be messing with things.");
                }
                fluidHandler.fill((FluidStack)ingredientTyped.getIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK).get(), IFluidHandler.FluidAction.EXECUTE);
                itemStack = fluidHandler.getContainer();
            }
            if (itemStack != null) {
                int slotPositionsCount = container.slots.size() - 36 - 4;
                for (int slot = 0; slot < slotPositionsCount; ++slot) {
                    int slotId = container.slots.size() - 36 - slotPositionsCount + slot;
                    Slot slotContainer = container.getSlot(slotId);
                    final Rect2i bounds = new Rect2i(screen.getGuiLeft() + slotContainer.x - 1, screen.getGuiTop() + slotContainer.y - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE);
                    int finalSlot = slot;
                    ItemStack finalItemStack = itemStack;
                    if (!element.isItemValidForSlot(slot, itemStack)) continue;
                    targets.add(new IGhostIngredientHandler.Target<I>((ContainerScreenLogicProgrammerBase)screen, finalSlot, finalItemStack){
                        final /* synthetic */ ContainerScreenLogicProgrammerBase val$screen;
                        final /* synthetic */ int val$finalSlot;
                        final /* synthetic */ ItemStack val$finalItemStack;
                        {
                            this.val$screen = containerScreenLogicProgrammerBase;
                            this.val$finalSlot = n;
                            this.val$finalItemStack = itemStack;
                        }

                        public Rect2i getArea() {
                            return bounds;
                        }

                        public void accept(I ingredient) {
                            LogicProgrammerGhostIngredientHandler.this.setStackInSlot(this.val$screen, this.val$finalSlot, this.val$finalItemStack);
                        }
                    });
                }
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    protected void setStackInSlot(T screen, int slot, ItemStack itemStack) {
        ContainerLogicProgrammerBase container = (ContainerLogicProgrammerBase)screen.getMenu();
        int slotPositionsCount = container.slots.size() - 36 - 4;
        int slotId = container.slots.size() - 36 - slotPositionsCount + slot;
        container.setItem(slotId, 0, itemStack.copy());
        IntegratedDynamicsCompat._instance.getPacketHandler().sendToServer((PacketBase)new CPacketSetSlot(container.containerId, slotId, itemStack));
    }
}

