/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class ItemWrench
extends Item {
    private static final Map<String, Mode> NAMED_MODES = Maps.newHashMap();
    private static final Map<Integer, Mode> INT_MODES = Maps.newHashMap();

    public ItemWrench(Item.Properties properties) {
        super(properties);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive() && !world.isClientSide()) {
            this.incrementMode(itemStack);
            player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.translatable((String)this.getMode(itemStack).getLabel())}), true);
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return super.use(world, player, hand);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        if (context.getPlayer() != null && context.getPlayer().isSecondaryUseActive()) {
            switch (this.getMode(itemStack).ordinal()) {
                case 1: {
                    itemStack.set(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS, (Object)context.getClickedPos());
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.saved", (Object[])new Object[]{context.getClickedPos().toShortString()}), true);
                    return InteractionResult.SUCCESS;
                }
                case 2: {
                    itemStack.set(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS, (Object)context.getClickedPos());
                    itemStack.set(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION, (Object)context.getClickedFace());
                    context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.saved", (Object[])new Object[]{context.getClickedPos().toShortString(), context.getClickedFace().getSerializedName()}), true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (context.getPlayer() != null && context.getPlayer().isSecondaryUseActive()) {
            return super.useOn(context);
        }
        ItemStack itemStack = context.getItemInHand();
        switch (this.getMode(itemStack).ordinal()) {
            case 0: {
                blockState = context.getClickedFace().getAxis() == Direction.Axis.Y && blockState.hasProperty((Property)BlockStateProperties.FACING) ? (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)(blockState.getValue((Property)BlockStateProperties.FACING) == Direction.UP ? Direction.DOWN : Direction.UP)) : (context.getClickedFace().getAxis() != Direction.Axis.Y && blockState.hasProperty((Property)BlockStateProperties.FACING) && ((Direction)blockState.getValue((Property)BlockStateProperties.FACING)).getAxis() == Direction.Axis.Y ? (BlockState)blockState.setValue((Property)BlockStateProperties.FACING, (Comparable)context.getClickedFace()) : blockState.rotate((LevelAccessor)context.getLevel(), context.getClickedPos(), Rotation.CLOCKWISE_90));
                context.getLevel().setBlockAndUpdate(context.getClickedPos(), blockState);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public Mode getMode(ItemStack itemStack) {
        return Objects.requireNonNullElse((Mode)((Object)itemStack.get(RegistryEntries.DATACOMPONENT_WRENCH_MODE)), Mode.DEFAULT);
    }

    public void setMode(ItemStack itemStack, Mode mode) {
        itemStack.set(RegistryEntries.DATACOMPONENT_WRENCH_MODE, (Object)mode);
    }

    public void incrementMode(ItemStack itemStack) {
        Mode mode = this.getMode(itemStack);
        int modeId = mode.ordinal();
        Mode nextMode = Mode.values()[(modeId + 1) % Mode.values().length];
        this.setMode(itemStack, nextMode);
        itemStack.remove(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS);
        itemStack.remove(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        Mode mode = this.getMode(itemStack);
        list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode", (Object[])new Object[]{Component.translatable((String)mode.getLabel())}));
        if (itemStack.has(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS)) {
            list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.pos", (Object[])new Object[]{((BlockPos)itemStack.get(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS)).toShortString()}).withStyle(ChatFormatting.GRAY));
        }
        if (itemStack.has(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION)) {
            list.add((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.side", (Object[])new Object[]{((Direction)itemStack.get(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION)).getSerializedName()}).withStyle(ChatFormatting.GRAY));
        }
        list.add((Component)Component.translatable((String)(mode.getLabel() + ".info")).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult performPartAction(BlockHitResult hit, IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand, PartPos center) {
        Mode mode = this.getMode(itemStack);
        switch (mode.ordinal()) {
            case 1: {
                if (itemStack.has(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS)) {
                    Vec3i offset = this.determineOffset(hit, itemStack);
                    if (partType.setTargetOffset(partState, center, offset)) {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.success"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
            case 2: {
                if (itemStack.has(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS) && itemStack.has(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION)) {
                    Vec3i offset = this.determineOffset(hit, itemStack);
                    Direction side = (Direction)itemStack.get(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_DIRECTION);
                    if (partType.setTargetOffset(partState, center, offset)) {
                        partType.setTargetSideOverride(partState, side);
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset_side.success"), true);
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.fail"), true);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.wrench.mode.offset.incomplete"), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected Vec3i determineOffset(BlockHitResult hit, ItemStack itemStack) {
        BlockPos source = hit.getBlockPos().relative(hit.getDirection());
        BlockPos targetAbs = (BlockPos)itemStack.get(RegistryEntries.DATACOMPONENT_WRENCH_TARGET_BLOCKPOS);
        return new Vec3i(targetAbs.getX() - source.getX(), targetAbs.getY() - source.getY(), targetAbs.getZ() - source.getZ());
    }

    public static enum Mode implements StringRepresentable
    {
        DEFAULT("integrateddynamics:default", "item.integrateddynamics.wrench.mode.default"),
        OFFSET("integrateddynamics:offset", "item.integrateddynamics.wrench.mode.offset"),
        OFFSET_SIDE("integrateddynamics:offset_side", "item.integrateddynamics.wrench.mode.offset_side");

        public static final StringRepresentable.EnumCodec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;
        private final String name;
        private final String label;

        private Mode(String name, String label) {
            this.name = name;
            this.label = label;
            NAMED_MODES.put(name, this);
            INT_MODES.put(this.ordinal(), this);
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getSerializedName() {
            return this.getName();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(INT_MODES::get, Enum::ordinal);
        }
    }
}

