/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.IngredientChannelAdapter;
import org.cyclops.integrateddynamics.core.network.PositionedAddonsNetworkIngredients;

public class IngredientChannelIndexed<T, M>
extends IngredientChannelAdapter<T, M> {
    private final IIngredientPositionsIndex<T, M> index;

    public IngredientChannelIndexed(PositionedAddonsNetworkIngredients<T, M> network, int channel, IIngredientPositionsIndex<T, M> index) {
        super(network, channel);
        this.index = index;
    }

    public IIngredientPositionsIndex<T, M> getIndex() {
        return this.index;
    }

    @Override
    protected Iterator<PartPos> getNonFullPositions() {
        this.scheduleObservation();
        return this.getNetwork().getPositions(this.getChannel()).iterator();
    }

    @Override
    protected Iterator<PartPos> getAllPositions() {
        this.scheduleObservation();
        return this.getNetwork().getPositions(this.getChannel()).iterator();
    }

    @Override
    protected Iterator<PartPos> getNonEmptyPositions() {
        this.scheduleObservation();
        return this.index.getNonEmptyPositions();
    }

    @Override
    protected Iterator<PartPos> getMatchingPositions(@Nonnull T prototype, M matchFlags) {
        this.scheduleObservation();
        return this.index.getPositions(prototype, matchFlags);
    }

    public Iterator<T> iterator() {
        this.scheduleObservation();
        return this.index.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchFlags) {
        this.scheduleObservation();
        return this.index.iterator(prototype, matchFlags);
    }
}

