/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.capability.energystorage.EnergyStorageItemBlockEnergyContainer;

public class ItemBlockEnergyContainer
extends ItemBlockNBT {
    private Block block;

    public ItemBlockEnergyContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = block;
    }

    public Block get() {
        return this.block;
    }

    public Optional<IEnergyStorage> getEnergyBattery(ItemStack itemStack) {
        return Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, list, flag);
        this.getEnergyBattery(itemStack).ifPresent(energyStorage -> {
            long amount = ((EnergyStorageItemBlockEnergyContainer)energyStorage).getEnergyStoredLong();
            long capacity = ((EnergyStorageItemBlockEnergyContainer)energyStorage).getMaxEnergyStoredLong();
            String line = String.format(Locale.ROOT, "%,d", amount) + " / " + String.format(Locale.ROOT, "%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]);
            list.add((Component)Component.literal((String)(String.valueOf(IInformationProvider.ITEM_PREFIX) + line)));
        });
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        return this.getEnergyBattery(itemStack).map(energyStorage -> {
            double amount = energyStorage.getEnergyStored();
            double capacity = energyStorage.getMaxEnergyStored();
            return (int)Math.round(amount / capacity * 13.0);
        }).orElse(0);
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public EnergyStorageItemBlockEnergyContainer createCapability(ItemStack itemStack) {
        return new EnergyStorageItemBlockEnergyContainer(this, this, itemStack){

            @Override
            public int getRate() {
                return BlockEntityEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
            }
        };
    }
}

