/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.capability.cable.CableTile;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.path.PathElementTile;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public abstract class BlockEntityCableConnectableInventory
extends CyclopsBlockEntity {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    private final ICable cable;
    private final INetworkCarrier networkCarrier;
    private final SimpleInventory inventory;

    public BlockEntityCableConnectableInventory(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize, int stackSize) {
        super(type, blockPos, blockState);
        this.inventory = this.createInventory(inventorySize, stackSize);
        this.cable = new CableTile<BlockEntityCableConnectableInventory>(this, this){

            @Override
            protected boolean isForceDisconnectable() {
                return false;
            }

            @Override
            protected EnumFacingMap<Boolean> getForceDisconnected() {
                return null;
            }

            @Override
            protected EnumFacingMap<Boolean> getConnected() {
                return ((BlockEntityCableConnectableInventory)this.tile).connected;
            }
        };
        this.networkCarrier = new NetworkCarrierDefault();
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public ICable getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public abstract INetworkElementProvider getNetworkElementProvider();

    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize);
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        super.read(tag, provider);
        this.connected.clear();
        this.inventory.readFromNBT(provider, tag, "inventory");
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.inventory.writeToNBT(provider, tag, "inventory");
        super.saveAdditional(tag, provider);
    }

    public void afterNetworkReAlive() {
    }

    @Nullable
    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public void onChunkUnloaded() {
        INetwork network;
        super.onChunkUnloaded();
        if (this.getLevel() != null && !this.getLevel().isClientSide && (network = this.getNetworkCarrier().getNetwork()) != null) {
            NetworkHelpers.invalidateNetworkElements(this.getLevel(), this.getBlockPos(), network, this.getNetworkElementProvider());
        }
    }

    public static class Ticker<T extends BlockEntityCableConnectableInventory>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityCableConnectableInventory)((Object)blockEntity)).getConnected().isEmpty()) {
                ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getCable().updateConnections();
            }
            NetworkHelpers.revalidateNetworkElements(level, pos);
        }
    }

    public static class CapabilityRegistrar<T extends BlockEntityCableConnectableInventory>
    extends BlockEntityCapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.Cable.BLOCK, (blockEntity, context) -> blockEntity.getCable());
            this.add(Capabilities.NetworkCarrier.BLOCK, (blockEntity, context) -> blockEntity.getNetworkCarrier());
            this.add(Capabilities.PathElement.BLOCK, (blockEntity, context) -> new PathElementTile<BlockEntityCableConnectableInventory>((BlockEntityCableConnectableInventory)((Object)blockEntity), blockEntity.getCable()));
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, context) -> blockEntity.getInventory().getItemHandler());
            this.add(Capabilities.InventoryState.BLOCK, (blockEntity, context) -> new SimpleInventoryState(blockEntity.getInventory()));
        }
    }
}

