/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.partcontainer;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public abstract class PartContainerDefault
implements IPartContainer {
    protected final EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData = EnumFacingMap.newMap();

    @Override
    public void update() {
        if (!MinecraftHelpers.isClientSideThread()) {
            for (PartHelpers.PartStateHolder partStateHolder : this.partData.values()) {
                if (partStateHolder.getState().isDirtyAndReset()) {
                    this.setChanged();
                }
                if (!partStateHolder.getState().isUpdateAndReset()) continue;
                this.sendUpdate();
            }
        }
    }

    @Override
    public DimPos getPosition() {
        return DimPos.of((Level)this.getLevel(), (BlockPos)this.getPos());
    }

    @Override
    public Map<Direction, IPartType<?, ?>> getParts() {
        return Maps.transformValues(this.partData, (Function)new Function<PartHelpers.PartStateHolder<?, ?>, IPartType<?, ?>>(this){

            @Nullable
            public IPartType<?, ?> apply(@Nullable PartHelpers.PartStateHolder<?, ?> input) {
                return input.getPart();
            }
        });
    }

    @Override
    public boolean hasParts() {
        return !this.partData.isEmpty();
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(Direction side, IPartType<P, S> part) {
        return !this.hasPart(side);
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setPart(final Direction side, final IPartType<P, S> part, final IPartState<P> partState) {
        PartHelpers.setPart(this.getNetwork(), this.getLevel(), this.getPos(), side, Objects.requireNonNull(part), Objects.requireNonNull(partState), new PartHelpers.IPartStateHolderCallback(){

            @Override
            public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                PartContainerDefault.this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(part, partState));
                PartContainerDefault.this.sendUpdate();
            }
        });
        this.onPartsChanged();
    }

    @Override
    public IPartType getPart(Direction side) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        return partStateHolder != null ? partStateHolder.getPart() : null;
    }

    @Override
    public boolean hasPart(Direction side) {
        return this.partData.containsKey((Object)side);
    }

    @Override
    public IPartType removePart(Direction side, Player player, boolean dropMainElement, boolean saveState) {
        PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
        if (partStateHolder == null) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "Attempted to remove a part at a side where no part was.");
            return null;
        }
        IPartType removed = partStateHolder.getPart();
        if (this.getNetwork() != null) {
            INetworkElement networkElement = removed.createNetworkElement(this, this.getPosition(), side);
            networkElement.onPreRemoved(this.getNetwork());
            if (!this.getNetwork().removeNetworkElementPre(networkElement)) {
                return null;
            }
            if (player != null && player.isCreative()) {
                dropMainElement = false;
            }
            LinkedList itemStacks = Lists.newLinkedList();
            networkElement.addDrops(itemStacks, dropMainElement, saveState);
            for (ItemStack itemStack : itemStacks) {
                if (player != null) {
                    ItemStackHelpers.spawnItemStackToPlayer((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)itemStack, (Player)player);
                    continue;
                }
                ItemStackHelpers.spawnItemStack((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)itemStack);
            }
            this.getNetwork().removeNetworkElementPost(networkElement);
            IPartType ret = ((PartHelpers.PartStateHolder)this.partData.remove((Object)side)).getPart();
            networkElement.onPostRemoved(this.getNetwork());
            this.onPartsChanged();
            return ret;
        }
        if (dropMainElement) {
            ItemStack itemStack = removed.getItemStack(ValueDeseralizationContext.of(player.level()), partStateHolder.getState(), saveState);
            if (player != null) {
                if (!player.isCreative()) {
                    ItemStackHelpers.spawnItemStackToPlayer((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)itemStack, (Player)player);
                }
            } else {
                ItemStackHelpers.spawnItemStack((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)itemStack);
            }
        }
        IPartType ret = ((PartHelpers.PartStateHolder)this.partData.remove((Object)side)).getPart();
        this.onPartsChanged();
        return ret;
    }

    @Override
    public void setPartState(Direction side, IPartState partState) throws PartStateException {
        if (!this.hasPart(side)) {
            throw new PartStateException(this.getPosition(), side);
        }
        this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(this.getPart(side), partState));
        this.onPartsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPartState getPartState(Direction side) throws PartStateException {
        EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> enumFacingMap = this.partData;
        synchronized (enumFacingMap) {
            PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)this.partData.get((Object)side);
            if (partStateHolder == null) {
                throw new PartStateException(this.getPosition(), side);
            }
            return partStateHolder.getState();
        }
    }

    @Override
    public <T> Optional<T> getCapability(PartCapability<T> partCapability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        IPartState partState;
        if (this.hasPart(target.getCenter().getSide()) && (partState = this.getPartState(target.getCenter().getSide())) != null) {
            return partState.getCapability(this.getPart(target.getCenter().getSide()), partCapability, network, partNetwork, target);
        }
        return Optional.empty();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        PartHelpers.writePartsToNBT(ValueDeseralizationContext.of(provider), this.getPos(), tag, this.partData);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> enumFacingMap = this.partData;
        synchronized (enumFacingMap) {
            PartHelpers.readPartsFromNBT(this.getNetwork(), this.getPos(), tag, this.partData, this.getLevel());
        }
    }

    protected void onPartsChanged() {
        this.setChanged();
        this.sendUpdate();
    }

    protected abstract void setChanged();

    protected abstract void sendUpdate();

    protected abstract Level getLevel();

    protected abstract BlockPos getPos();

    protected abstract INetwork getNetwork();

    protected Optional<IPartNetwork> getPartNetwork() {
        return NetworkHelpers.getPartNetwork(this.getNetwork());
    }

    public EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partData;
    }

    public void setPartData(Map<Direction, PartHelpers.PartStateHolder<?, ?>> partData) {
        this.partData.clear();
        this.partData.putAll(partData);
    }

    public void silentResetPartData() {
        this.partData.clear();
    }
}

