/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.OutputItemHandler;
import de.maxhenkel.easyvillagers.blocks.FarmerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FarmerTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected BlockState crop;
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected ItemStackHandler itemHandler = new ItemStackHandler(this.inventory);
    protected OutputItemHandler outputItemHandler = new OutputItemHandler(this.inventory);

    public FarmerTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.FARMER.get(), ((FarmerBlock)ModBlocks.FARMER.get()).defaultBlockState(), pos, state);
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        if (villager.getVillagerXp() <= 0 && !villager.getVillagerData().getProfession().equals((Object)VillagerProfession.NITWIT)) {
            villager.setVillagerData(villager.getVillagerData().setProfession(VillagerProfession.FARMER));
        }
    }

    public void setCrop(Item seed) {
        this.crop = seed == null ? null : this.getSeedCrop(seed);
        this.setChanged();
        this.sync();
    }

    public Block removeSeed() {
        if (this.crop == null) {
            return null;
        }
        Block s = this.crop.getBlock();
        this.setCrop(null);
        return s;
    }

    public boolean isValidSeed(Item seed) {
        return this.getSeedCrop(seed) != null;
    }

    public BlockState getSeedCrop(Item seed) {
        ItemStack seedStack = new ItemStack((ItemLike)seed);
        if (!(seed instanceof BlockItem)) {
            return null;
        }
        BlockItem blockitem = (BlockItem)seed;
        if (!seedStack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS)) {
            return null;
        }
        return blockitem.getBlock().defaultBlockState();
    }

    @Nullable
    public BlockState getCrop() {
        return this.crop;
    }

    @Override
    public void tickServer() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v != null) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
            if (this.advanceAge()) {
                this.sync();
            }
            this.setChanged();
        }
        if (this.level.getGameTime() % 20L == 0L && this.level.random.nextInt(((Integer)Main.SERVER_CONFIG.farmSpeed.get()).intValue()) == 0 && this.ageCrop(v)) {
            this.sync();
            this.setChanged();
        }
    }

    private boolean ageCrop(@Nullable EasyVillagerEntity villager) {
        BlockState c = this.getCrop();
        if (c == null) {
            return false;
        }
        Optional<Property> ageProp = c.getProperties().stream().filter(p -> p.getName().equals("age")).findFirst();
        if (!ageProp.isPresent() || !(ageProp.get() instanceof IntegerProperty)) {
            return false;
        }
        IntegerProperty p2 = (IntegerProperty)ageProp.get();
        Integer max = (Integer)p2.getPossibleValues().stream().max(Integer::compare).get();
        int age = (Integer)c.getValue((Property)p2);
        if (age >= max) {
            if (villager == null || villager.isBaby() || !villager.getVillagerData().getProfession().equals((Object)VillagerProfession.FARMER)) {
                return false;
            }
            LootParams.Builder context = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ())).withParameter(LootContextParams.BLOCK_STATE, (Object)c).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY);
            List drops = c.getDrops(context);
            for (ItemStack stack : drops) {
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    stack = this.itemHandler.insertItem(i, stack, false);
                }
            }
            this.crop = (BlockState)this.crop.setValue((Property)p2, (Comparable)Integer.valueOf(0));
            VillagerBlockBase.playVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_WORK_FARMER);
            return true;
        }
        this.crop = (BlockState)this.crop.setValue((Property)p2, (Comparable)Integer.valueOf(age + 1));
        return true;
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.inventory, () -> ((FarmerTileentity)this).setChanged());
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.crop != null) {
            compound.put("Crop", (Tag)NbtUtils.writeBlockState((BlockState)this.crop));
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.inventory, (boolean)false, (HolderLookup.Provider)provider);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        if (compound.contains("Crop")) {
            this.crop = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)compound.getCompound("Crop"));
        } else {
            this.removeSeed();
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.inventory, (HolderLookup.Provider)provider);
        super.loadAdditional(compound, provider);
    }

    public IItemHandler getItemHandler() {
        return this.outputItemHandler;
    }
}

