/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.inventory.slot.SlotFilter;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemTag;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class FilterSettings {
    public final ItemStackHandlerAA filterInventory;
    public boolean isWhitelist;
    public boolean respectMod;
    public boolean matchDamage;
    public boolean matchNBT;
    private boolean lastWhitelist;
    private boolean lastRespectMod;
    private boolean lastMatchDamage;
    private boolean lastMatchNBT;

    public FilterSettings(int slots, boolean defaultWhitelist, boolean defaultRespectMod, boolean defaultMatchDamage, boolean defaultMatchNBT) {
        this.filterInventory = new ItemStackHandlerAA(slots){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                FilterSettings.this.onContentsChanged();
            }
        };
        this.isWhitelist = defaultWhitelist;
        this.respectMod = defaultRespectMod;
        this.matchDamage = defaultMatchDamage;
        this.matchNBT = defaultMatchNBT;
    }

    public void onContentsChanged() {
    }

    public static boolean check(ItemStack stack, ItemStackHandlerAA filter, boolean whitelist, boolean mod, boolean damage, boolean nbt) {
        if (!stack.isEmpty()) {
            for (int i = 0; i < filter.getSlots(); ++i) {
                TagKey tag;
                ResourceLocation tagLocation;
                ItemStack slot = filter.getStackInSlot(i);
                if (slot.isEmpty()) continue;
                if (SlotFilter.isFilter(slot)) {
                    ItemStackHandlerAA inv = new ItemStackHandlerAA(24);
                    DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, slot);
                    for (int k = 0; k < inv.getSlots(); ++k) {
                        ItemStack filterSlot = inv.getStackInSlot(k);
                        if (filterSlot.isEmpty() || !FilterSettings.areEqualEnough(filterSlot, stack, mod, damage, nbt)) continue;
                        return whitelist;
                    }
                    continue;
                }
                if (!(slot.getItem() instanceof ItemTag ? (tagLocation = (ResourceLocation)slot.get(ActuallyComponents.ITEM_TAG)) != null && stack.is(tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation)) : FilterSettings.areEqualEnough(slot, stack, mod, damage, nbt))) continue;
                return whitelist;
            }
        }
        return !whitelist;
    }

    private static boolean areEqualEnough(ItemStack first, ItemStack second, boolean mod, boolean damage, boolean nbt) {
        if (mod) {
            return FilterSettings.checkMod(first, second) && FilterSettings.checkDamage(first, second, damage);
        }
        return FilterSettings.checkItem(first, second, nbt) && FilterSettings.checkDamage(first, second, damage);
    }

    public static boolean checkDamage(ItemStack first, ItemStack second, boolean damage) {
        return !damage || first.getDamageValue() == second.getDamageValue();
    }

    public static boolean checkItem(ItemStack first, ItemStack second, boolean nbt) {
        return nbt ? ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second) : ItemStack.isSameItem((ItemStack)first, (ItemStack)second);
    }

    public static boolean checkMod(ItemStack first, ItemStack second) {
        return BuiltInRegistries.ITEM.getKey((Object)first.getItem()).getNamespace().equals(BuiltInRegistries.ITEM.getKey((Object)second.getItem()).getNamespace());
    }

    public void writeToNBT(HolderLookup.Provider provider, CompoundTag tag, String name) {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Whitelist", this.isWhitelist);
        compound.putBoolean("Mod", this.respectMod);
        compound.putBoolean("Damage", this.matchDamage);
        compound.putBoolean("NBT", this.matchNBT);
        compound.put("Items", (Tag)this.filterInventory.serializeNBT(provider));
        tag.put(name, (Tag)compound);
    }

    public void readFromNBT(HolderLookup.Provider provider, CompoundTag tag, String name) {
        CompoundTag compound = tag.getCompound(name);
        this.isWhitelist = compound.getBoolean("Whitelist");
        this.respectMod = compound.getBoolean("Mod");
        this.matchDamage = compound.getBoolean("Damage");
        this.matchNBT = compound.getBoolean("NBT");
        this.filterInventory.deserializeNBT(provider, compound.getCompound("Items"));
    }

    public boolean needsUpdateSend() {
        return this.lastWhitelist != this.isWhitelist || this.lastRespectMod != this.respectMod || this.lastMatchDamage != this.matchDamage || this.lastMatchNBT != this.matchNBT;
    }

    public void updateLasts() {
        this.lastWhitelist = this.isWhitelist;
        this.lastRespectMod = this.respectMod;
        this.lastMatchDamage = this.matchDamage;
        this.lastMatchNBT = this.matchNBT;
    }

    public void onButtonPressed(int id) {
        if (id == Buttons.WHITELIST.ordinal()) {
            this.isWhitelist = !this.isWhitelist;
        } else if (id == Buttons.MOD.ordinal()) {
            this.respectMod = !this.respectMod;
        } else if (id == Buttons.DAMAGE.ordinal()) {
            this.matchDamage = !this.matchDamage;
        } else if (id == Buttons.NBT.ordinal()) {
            this.matchNBT = !this.matchNBT;
        }
    }

    public boolean check(ItemStack stack) {
        return !this.needsCheck() || FilterSettings.check(stack, this.filterInventory, this.isWhitelist, this.respectMod, this.matchDamage, this.matchNBT);
    }

    public boolean needsCheck() {
        for (int i = 0; i < this.filterInventory.getSlots(); ++i) {
            if (this.filterInventory.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return this.isWhitelist;
    }

    public static enum Buttons {
        WHITELIST,
        MOD,
        DAMAGE,
        NBT;

    }
}

