/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.CoffeeIngredientRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.CrushingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.FermentingRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.LaserRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.MiningLensRecipe;
import de.ellpeck.actuallyadditions.mod.crafting.PressingRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.gui.CrusherScreen;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.jei.coffee.CoffeeMachineCategory;
import de.ellpeck.actuallyadditions.mod.jei.crusher.CrusherCategory;
import de.ellpeck.actuallyadditions.mod.jei.empowerer.EmpowererRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.fermenting.FermentingCategory;
import de.ellpeck.actuallyadditions.mod.jei.laser.LaserRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.lens.MiningLensRecipeCategory;
import de.ellpeck.actuallyadditions.mod.jei.pressing.PressingCategory;
import de.ellpeck.actuallyadditions.mod.util.CapHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIActuallyAdditionsPlugin
implements IModPlugin {
    public static final ResourceLocation ID = ActuallyAdditions.modLoc("jei_plugin");
    public static final RecipeType<FermentingRecipe> FERMENTING = RecipeType.create((String)"actuallyadditions", (String)"fermenting", FermentingRecipe.class);
    public static final RecipeType<PressingRecipe> PRESSING = RecipeType.create((String)"actuallyadditions", (String)"pressing", PressingRecipe.class);
    public static final RecipeType<LaserRecipe> LASER = RecipeType.create((String)"actuallyadditions", (String)"laser", LaserRecipe.class);
    public static final RecipeType<EmpowererRecipe> EMPOWERER = RecipeType.create((String)"actuallyadditions", (String)"empowerer", EmpowererRecipe.class);
    public static final RecipeType<CoffeeIngredientRecipe> COFFEE_MACHINE = RecipeType.create((String)"actuallyadditions", (String)"coffee_machine", CoffeeIngredientRecipe.class);
    public static final RecipeType<CrushingRecipe> CRUSHING = RecipeType.create((String)"actuallyadditions", (String)"crushing", CrushingRecipe.class);
    public static final RecipeType<MiningLensRecipe> MINING_LENS = RecipeType.create((String)"actuallyadditions", (String)"mining_lens", MiningLensRecipe.class);

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(@Nonnull ISubtypeRegistration reg) {
        ActuallyItems.ITEMS.getEntries().forEach(entry -> {
            if (entry.get() instanceof ItemEnergy) {
                reg.registerSubtypeInterpreter((Item)entry.get(), (ingredient, context) -> CapHelper.getEnergyStorage(ingredient).flatMap(storage -> {
                    if (storage.getEnergyStored() == storage.getMaxEnergyStored()) {
                        return Optional.of("charged");
                    }
                    return Optional.of("uncharged");
                }).orElse("uncharged"));
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers helpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new FermentingCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new LaserRecipeCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new EmpowererRecipeCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CoffeeMachineCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new PressingCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrusherCategory(helpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new MiningLensRecipeCategory(helpers.getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyItems.CRAFTER_ON_A_STICK.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.POWERED_FURNACE.getItem()), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.FERMENTING_BARREL.getItem()), new RecipeType[]{FERMENTING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.getItem()), new RecipeType[]{LASER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.EMPOWERER.getItem()), new RecipeType[]{EMPOWERER});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.COFFEE_MACHINE.getItem()), new RecipeType[]{COFFEE_MACHINE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.CANOLA_PRESS.getItem()), new RecipeType[]{PRESSING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.CRUSHER.getItem()), new RecipeType[]{CRUSHING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyBlocks.CRUSHER_DOUBLE.getItem()), new RecipeType[]{CRUSHING});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ActuallyItems.LENS_OF_THE_MINER.get()), new RecipeType[]{MINING_LENS});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientLevel level = Minecraft.getInstance().level;
        registry.addRecipes(FERMENTING, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.FERMENTING.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(LASER, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.LASER.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(EMPOWERER, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.EMPOWERING.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(COFFEE_MACHINE, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.COFFEE_INGREDIENT.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(PRESSING, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.PRESSING.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(CRUSHING, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.CRUSHING.get()).stream().map(RecipeHolder::value).toList());
        registry.addRecipes(MINING_LENS, level.getRecipeManager().getAllRecipesFor(ActuallyRecipes.Types.MINING_LENS.get()).stream().map(RecipeHolder::value).toList());
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GuiCoffeeMachine.class, 53, 42, 22, 16, new RecipeType[]{COFFEE_MACHINE});
        registration.addRecipeClickArea(CrusherScreen.class, 80, 40, 24, 22, new RecipeType[]{CRUSHING});
        registration.addRecipeClickArea(CrusherScreen.CrusherDoubleScreen.class, 51, 40, 74, 22, new RecipeType[]{CRUSHING});
        registration.addRecipeClickArea(GuiFurnaceDouble.class, 51, 40, 74, 22, new RecipeType[]{RecipeTypes.SMELTING});
    }
}

