/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items.base;

import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class ItemEnergy
extends ItemBase {
    public final int maxPower;
    public final int transfer;

    public ItemEnergy(int maxPower, int transfer) {
        super(ActuallyItems.defaultProps().stacksTo(1));
        this.maxPower = maxPower;
        this.transfer = transfer;
    }

    public ItemEnergy(Item.Properties props, int maxPower, int transfer) {
        super(props);
        this.maxPower = maxPower;
        this.transfer = transfer;
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage != null) {
            int energy = storage.getEnergyStored();
            NumberFormat format = NumberFormat.getInstance();
            tooltip.add((Component)Component.translatable((String)"misc.actuallyadditions.power_long", (Object[])new Object[]{format.format(energy), format.format(storage.getMaxEnergyStored())}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (storage != null) {
            return Math.round(13.0f / (float)storage.getMaxEnergyStored() * (float)storage.getEnergyStored());
        }
        return 0;
    }

    public int getBarColor(ItemStack stack) {
        int defaultColor = super.getBarColor(stack);
        if (FMLEnvironment.dist.isClient()) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return defaultColor;
            }
            float[] color = AssetUtil.getWheelColor(mc.player.level().getGameTime() % 256L);
            return Mth.color((float)(color[0] / 255.0f), (float)(color[1] / 255.0f), (float)(color[2] / 255.0f));
        }
        return defaultColor;
    }

    public void setEnergy(ItemStack stack, int energy) {
        Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(cap -> {
            if (cap instanceof CustomEnergyStorage) {
                ((CustomEnergyStorage)((Object)cap)).setEnergyStored(energy);
            }
        });
    }

    @Deprecated
    public int receiveEnergyInternal(ItemStack stack, int maxReceive, boolean simulate) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(cap -> cap.receiveEnergy(maxReceive, simulate)).orElse(0);
    }

    public int extractEnergyInternal(ItemStack stack, int maxExtract, boolean simulate) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(cap -> cap instanceof EnergyStorage ? cap.extractEnergy(maxExtract, simulate) : 0).orElse(0);
    }

    @Deprecated
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(cap -> cap.receiveEnergy(maxReceive, simulate)).orElse(0);
    }

    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(cap -> cap.extractEnergy(maxExtract, simulate)).orElse(0);
    }

    public int getEnergyStored(ItemStack stack) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        return Optional.ofNullable((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    public int getEnergyStorage(ItemStack stack) {
        return (Integer)stack.getOrDefault(ActuallyComponents.ENERGY_STORAGE, (Object)0);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getEnergyStorage(stack);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }
}

