/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemMagnetRing
extends ItemEnergy {
    public ItemMagnetRing() {
        super(200000, 1000);
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return !ItemUtil.isEnabled(stack);
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.isClientSide && !ItemUtil.isEnabled(stack)) {
                if (player.isCreative() || player.isSpectator()) {
                    return;
                }
                if (!entity.isShiftKeyDown()) {
                    int range = 5;
                    List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(entity.getX() - (double)range, entity.getY() - (double)range, entity.getZ() - (double)range, entity.getX() + (double)range, entity.getY() + (double)range, entity.getZ() + (double)range));
                    if (!items.isEmpty()) {
                        for (ItemEntity item : items) {
                            if (item.getPersistentData().getBoolean("PreventRemoteMovement") || !item.isAlive() || item.hasPickUpDelay()) continue;
                            int energyForItem = 50 * item.getItem().getCount();
                            if (this.getEnergyStored(stack) < energyForItem) continue;
                            ItemStack oldItem = item.getItem().copy();
                            item.playerTouch(player);
                            if (player.isCreative() || item.isAlive() && ItemStack.matches((ItemStack)item.getItem(), (ItemStack)oldItem)) continue;
                            this.extractEnergy(stack, energyForItem, false);
                        }
                    }
                }
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!worldIn.isClientSide && player.isShiftKeyDown()) {
            ItemUtil.changeEnabled(player, hand);
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return super.use(worldIn, player, hand);
    }
}

