/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerDrill;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.items.base.ItemEnergy;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class DrillItem
extends ItemEnergy {
    public static final int HARVEST_LEVEL = 4;
    private static final int ENERGY_USE = 100;
    private static final List<ItemAbility> ACTIONS = List.of(ItemAbilities.SHOVEL_DIG, ItemAbilities.PICKAXE_DIG);
    private final ItemAttributeModifiers attributes_unpowered;
    private final ItemAttributeModifiers attributes_powered;
    private Set<UUID> breakers = new HashSet<UUID>();

    public DrillItem() {
        super(ActuallyItems.defaultProps().stacksTo(1).component(DataComponents.TOOL, (Object)Tiers.NETHERITE.createToolProperties(ActuallyTags.Blocks.MINEABLE_WITH_DRILL)), 250000, 1000);
        this.attributes_unpowered = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ActuallyAdditions.modLoc("drill_attack"), (double)0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(ActuallyAdditions.modLoc("drill_speed"), 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
        this.attributes_powered = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ActuallyAdditions.modLoc("drill_attack"), 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(ActuallyAdditions.modLoc("drill_speed"), 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canPerformAction(@Nonnull ItemStack stack, @Nonnull ItemAbility toolAction) {
        return ACTIONS.contains(toolAction);
    }

    public static void loadSlotsFromNBT(IItemHandlerModifiable slots, ItemStack stack) {
        if (stack.has(ActuallyComponents.CONTENTS)) {
            ItemContainerContents containerContents = (ItemContainerContents)stack.getOrDefault(ActuallyComponents.CONTENTS, (Object)ItemContainerContents.EMPTY);
            int slotCount = slots.getSlots();
            for (int i = 0; i < slotCount; ++i) {
                slots.setStackInSlot(i, i < containerContents.getSlots() ? containerContents.getStackInSlot(i) : ItemStack.EMPTY);
            }
        }
    }

    public static void writeSlotsToNBT(IItemHandler slots, ItemStack stack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < slots.getSlots(); ++i) {
            stacks.add(slots.getStackInSlot(i));
        }
        stack.set(ActuallyComponents.CONTENTS, (Object)ItemContainerContents.fromItems(stacks));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack equip;
        int slot;
        InteractionHand hand;
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(hand = context.getHand());
        ItemStack upgrade = this.getHasUpgradeAsStack(stack, ItemDrillUpgrade.UpgradeType.PLACER);
        if (!upgrade.isEmpty() && (slot = ItemDrillUpgrade.getSlotToPlaceFrom(upgrade)) >= 0 && slot < 9 && !(equip = player.getInventory().getItem(slot)).isEmpty() && equip != stack) {
            ItemStack toPlaceStack = equip;
            BlockHitResult result = new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside());
            return toPlaceStack.useOn(new UseOnContext(level, player, hand, toPlaceStack, result));
        }
        return super.useOn(context);
    }

    public ItemStack getHasUpgradeAsStack(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        ItemStackHandlerAA inv = new ItemStackHandlerAA(5);
        DrillItem.loadSlotsFromNBT((IItemHandlerModifiable)inv, stack);
        for (int i = 0; i < inv.getSlots(); ++i) {
            Item item;
            ItemStack slotStack = inv.getStackInSlot(i);
            if (slotStack.isEmpty() || !((item = slotStack.getItem()) instanceof ItemDrillUpgrade)) continue;
            ItemDrillUpgrade drillUpgrade = (ItemDrillUpgrade)item;
            if (drillUpgrade.type != upgrade) continue;
            return slotStack;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if (!world.isClientSide && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ContainerDrill(id, inv), (Component)Component.translatable((String)"container.actuallyadditions.drill")));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.getItemInHand(hand));
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entityHit, @Nonnull InteractionHand hand) {
        int use = this.getEnergyUsePerBlock(stack);
        if (!(entityHit instanceof Player && ((Player)entityHit).isCreative() || this.getEnergyStored(stack) < use)) {
            this.extractEnergy(stack, use, false);
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@Nonnull ItemStack stack) {
        return this.getEnergyStored(stack) >= 100 ? this.attributes_powered : this.attributes_unpowered;
    }

    public float getDestroySpeed(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) ? (this.hasExtraWhitelist(state.getBlock()) || state.is(ActuallyTags.Blocks.MINEABLE_WITH_DRILL) ? this.getEfficiencyFromUpgrade(stack) : 1.0f) : 0.1f;
    }

    public boolean onBreakBlock(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull Player player) {
        if (!this.breakers.add(player.getUUID())) {
            return false;
        }
        Level level = player.level();
        boolean toReturn = false;
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
                ItemUtil.addEnchantment(stack, (Holder<Enchantment>)level.holderOrThrow(Enchantments.SILK_TOUCH), 1, level.registryAccess());
            } else if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
                ItemUtil.addEnchantment(stack, (Holder<Enchantment>)level.holderOrThrow(Enchantments.FORTUNE), this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II) ? 3 : 1, level.registryAccess());
            }
            HitResult ray = player.pick(Util.getReachDistance(player), 1.0f, false);
            if (ray instanceof BlockHitResult) {
                BlockHitResult trace = (BlockHitResult)ray;
                toReturn = !player.isShiftKeyDown() && this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE) ? this.breakBlocks(stack, 2, player.level(), pos, trace.getDirection(), player) : this.breakBlocks(stack, 1, player.level(), pos, trace.getDirection(), player)) : this.breakBlocks(stack, 0, player.level(), pos, trace.getDirection(), player);
                ItemUtil.removeEnchantment(stack, (Holder<Enchantment>)level.holderOrThrow(Enchantments.SILK_TOUCH), level.registryAccess());
                ItemUtil.removeEnchantment(stack, (Holder<Enchantment>)level.holderOrThrow(Enchantments.FORTUNE), level.registryAccess());
            }
        }
        this.breakers.remove(player.getUUID());
        return toReturn;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.getEnergyStored(stack) >= this.getEnergyUsePerBlock(stack) && super.isCorrectToolForDrops(stack, state);
    }

    public int getEnergyUsePerBlock(ItemStack stack) {
        int use = 100;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            use += 50;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II)) {
                use += 75;
                if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III)) {
                    use += 175;
                }
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SILK_TOUCH)) {
            use += 100;
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE)) {
            use += 40;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FORTUNE_II)) {
                use += 80;
            }
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            use += 10;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                use += 30;
            }
        }
        return use;
    }

    public boolean getHasUpgrade(ItemStack stack, ItemDrillUpgrade.UpgradeType upgrade) {
        return !this.getHasUpgradeAsStack(stack, upgrade).isEmpty();
    }

    public float getEfficiencyFromUpgrade(ItemStack stack) {
        float efficiency = 8.0f;
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED)) {
            efficiency = this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_II) ? (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.SPEED_III) ? (efficiency += 37.0f) : (efficiency += 25.0f)) : (efficiency += 8.0f);
        }
        if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
            efficiency *= 0.5f;
            if (this.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                efficiency *= 0.35f;
            }
        }
        return efficiency;
    }

    public boolean breakBlocks(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.getAxis() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.getAxis() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.getBlockState(aPos);
        float mainHardness = state.getDestroySpeed((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (this.getEnergyStored(stack) >= use) {
            if (!this.tryHarvestBlock(world, aPos, false, stack, player, use)) {
                return false;
            }
        } else {
            return false;
        }
        if (radius == 2 && side.getAxis() != Direction.Axis.Y && (theState = world.getBlockState(aPos = aPos.above())).getDestroySpeed((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            this.tryHarvestBlock(world, aPos, true, stack, player, use);
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.getX() - xRange; xPos <= aPos.getX() + xRange; ++xPos) {
                for (int yPos = aPos.getY() - yRange; yPos <= aPos.getY() + yRange; ++yPos) {
                    for (int zPos = aPos.getZ() - zRange; zPos <= aPos.getZ() + zRange; ++zPos) {
                        if (aPos.getX() == xPos && aPos.getY() == yPos && aPos.getZ() == zPos) continue;
                        if (this.getEnergyStored(stack) >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.getBlockState(thePos);
                            if (!(theState2.getDestroySpeed((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            this.tryHarvestBlock(world, thePos, true, stack, player, use);
                            continue;
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public List<BlockPos> gatherBreakingPositions(ItemStack stack, int radius, Level world, BlockPos aPos, Direction side, Player player) {
        BlockState theState;
        int energyStored = this.getEnergyStored(stack);
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int xRange = radius;
        int yRange = radius;
        int zRange = 0;
        if (side.getAxis() == Direction.Axis.Y) {
            zRange = radius;
            yRange = 0;
        }
        if (side.getAxis() == Direction.Axis.X) {
            xRange = 0;
            zRange = radius;
        }
        BlockState state = world.getBlockState(aPos);
        float mainHardness = state.getDestroySpeed((BlockGetter)world, aPos);
        int use = this.getEnergyUsePerBlock(stack);
        if (energyStored < use) {
            return positions;
        }
        if (radius == 2 && side.getAxis() != Direction.Axis.Y && (theState = world.getBlockState(aPos = aPos.above())).getDestroySpeed((BlockGetter)world, aPos) <= mainHardness + 5.0f) {
            positions.add(aPos.immutable());
        }
        if (radius > 0 && mainHardness >= 0.2f) {
            for (int xPos = aPos.getX() - xRange; xPos <= aPos.getX() + xRange; ++xPos) {
                for (int yPos = aPos.getY() - yRange; yPos <= aPos.getY() + yRange; ++yPos) {
                    for (int zPos = aPos.getZ() - zRange; zPos <= aPos.getZ() + zRange; ++zPos) {
                        if (aPos.getX() == xPos && aPos.getY() == yPos && aPos.getZ() == zPos) continue;
                        if (energyStored >= use) {
                            BlockPos thePos = new BlockPos(xPos, yPos, zPos);
                            BlockState theState2 = world.getBlockState(thePos);
                            if (!(theState2.getDestroySpeed((BlockGetter)world, thePos) <= mainHardness + 5.0f)) continue;
                            energyStored -= use;
                            positions.add(thePos.immutable());
                            continue;
                        }
                        return positions;
                    }
                }
            }
        }
        return positions;
    }

    private boolean tryHarvestBlock(Level level, BlockPos pos, boolean isExtra, ItemStack stack, Player player, int use) {
        boolean canHarvest;
        BlockState state = level.getBlockState(pos);
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        boolean bl = canHarvest = !(!player.hasCorrectToolForDrops(state) && !this.isCorrectToolForDrops(stack, state) || isExtra && !(this.getDestroySpeed(stack, level.getBlockState(pos)) > 1.0f));
        if (hardness >= 0.0f && (!isExtra || canHarvest && !state.hasBlockEntity())) {
            if (!player.isCreative()) {
                this.extractEnergy(stack, use, false);
            }
            return WorldUtil.breakExtraBlock(stack, level, player, pos);
        }
        return false;
    }

    private boolean hasExtraWhitelist(Block block) {
        String name;
        ResourceLocation location;
        if (block != null && (location = BuiltInRegistries.BLOCK.getKey((Object)block)) != null && (name = location.toString()) != null) {
            for (String s : (List)CommonConfig.ItemSettings.DRILL_EXTRA_MINING_WHITELIST.get()) {
                if (s == null || !s.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack oldStack, @Nonnull ItemStack newStack) {
        return !ItemStack.isSameItem((ItemStack)newStack, (ItemStack)oldStack);
    }
}

