/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FilterSettingsGui {
    private final FilterSettings theSettings;
    public Button whitelistButton;
    public Button modButton;
    public Button damageButton;
    public Button nbtButton;

    public FilterSettingsGui(FilterSettings settings, int x, int y, boolean vertical, Consumer<AbstractButton> buttonConsumer, Consumer<Integer> clickConsumer, int idOffset) {
        this.theSettings = settings;
        this.whitelistButton = Button.builder((Component)Component.literal((String)"WH"), $ -> {
            this.theSettings.isWhitelist = !this.theSettings.isWhitelist;
            clickConsumer.accept(idOffset);
        }).bounds(x, y, 16, 12).build();
        buttonConsumer.accept((AbstractButton)this.whitelistButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.modButton = Button.builder((Component)Component.literal((String)"MO"), $ -> {
            this.theSettings.respectMod = !this.theSettings.respectMod;
            clickConsumer.accept(idOffset + 1);
        }).bounds(x, y, 16, 12).build();
        buttonConsumer.accept((AbstractButton)this.modButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.damageButton = Button.builder((Component)Component.literal((String)"DM"), $ -> {
            this.theSettings.matchDamage = !this.theSettings.matchDamage;
            clickConsumer.accept(idOffset + 2);
        }).bounds(x, y, 16, 12).build();
        buttonConsumer.accept((AbstractButton)this.damageButton);
        if (vertical) {
            y += 14;
        } else {
            x += 18;
        }
        this.nbtButton = Button.builder((Component)Component.literal((String)"DA"), $ -> {
            this.theSettings.matchNBT = !this.theSettings.matchNBT;
            clickConsumer.accept(idOffset + 2);
        }).bounds(x, y, 16, 12).build();
        buttonConsumer.accept((AbstractButton)this.nbtButton);
        this.tick();
    }

    public void tick() {
        this.whitelistButton.setMessage((Component)Component.literal((String)"WH").withStyle(this.theSettings.isWhitelist ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.modButton.setMessage((Component)Component.literal((String)"MO").withStyle(this.theSettings.respectMod ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.damageButton.setMessage((Component)Component.literal((String)"DM").withStyle(this.theSettings.matchDamage ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
        this.nbtButton.setMessage((Component)Component.literal((String)"DA").withStyle(this.theSettings.matchNBT ? ChatFormatting.DARK_GREEN : ChatFormatting.RED));
    }

    public void drawHover(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getInstance();
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (this.whitelistButton.isMouseOver((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.isWhitelist ? Component.translatable((String)"info.actuallyadditions.gui.whitelist") : Component.translatable((String)"info.actuallyadditions.gui.blacklist")).withStyle(ChatFormatting.BOLD));
            list.add(Component.translatable((String)"info.actuallyadditions.gui.whitelistInfo"));
        } else if (this.modButton.isMouseOver((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.respectMod ? Component.translatable((String)"info.actuallyadditions.gui.respectMod") : Component.translatable((String)"info.actuallyadditions.gui.ignoreMod")).withStyle(ChatFormatting.BOLD));
            list.add(Component.translatable((String)"info.actuallyadditions.gui.respectModInfo"));
            list.add(Component.translatable((String)"info.actuallyadditions.gui.respectModInfo2"));
        } else if (this.damageButton.isMouseOver((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.matchDamage ? Component.translatable((String)"info.actuallyadditions.gui.respectDamage") : Component.translatable((String)"info.actuallyadditions.gui.ignoreDamage")).withStyle(ChatFormatting.BOLD));
        } else if (this.nbtButton.isMouseOver((double)mouseX, (double)mouseY)) {
            list.add((this.theSettings.matchNBT ? Component.translatable((String)"info.actuallyadditions.gui.respectNBT") : Component.translatable((String)"info.actuallyadditions.gui.ignoreNBT")).withStyle(ChatFormatting.BOLD));
        }
        if (!list.isEmpty()) {
            guiGraphics.renderComponentTooltip(mc.font, list, mouseX, mouseY);
        }
    }
}

