/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen.modifier;

import com.mojang.serialization.MapCodec;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyBiomeModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record BoolConfigFeatureBiomeModifier(HolderSet<Biome> biomes, HolderSet<PlacedFeature> features, GenerationStep.Decoration step, String boolConfig) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.checkConfig() && this.biomes.contains(biome)) {
            BiomeGenerationSettingsBuilder generationSettings = builder.getGenerationSettings();
            this.features.forEach(holder -> generationSettings.addFeature(this.step, holder));
        }
    }

    private boolean checkConfig() {
        switch (this.boolConfig) {
            default: {
                return true;
            }
            case "generateQuartz": {
                return (Boolean)CommonConfig.Worldgen.GENERATE_QUARTZ.get();
            }
            case "generateCanola": {
                return (Boolean)CommonConfig.Worldgen.GENERATE_CANOLA.get();
            }
            case "generateFlax": {
                return (Boolean)CommonConfig.Worldgen.GENERATE_FLAX.get();
            }
            case "generateCoffee": 
        }
        return (Boolean)CommonConfig.Worldgen.GENERATE_COFFEE.get();
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return ActuallyBiomeModifiers.BOOL_CONFIG_MODIFIER.get();
    }
}

