/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.BlockLaserRelay;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemTag;
import de.ellpeck.actuallyadditions.mod.items.Sack;
import de.ellpeck.actuallyadditions.mod.network.PacketHelperServer;
import de.ellpeck.actuallyadditions.mod.sack.SackManager;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class CommonEvents {
    @SubscribeEvent
    public void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        if (event.getLevel().getBlockState(event.getHitVec().getBlockPos()).getBlock() instanceof BlockLaserRelay && event.getItemStack().is(CommonConfig.Other.relayConfigureItem)) {
            event.setUseItem(TriState.FALSE);
            event.setUseBlock(TriState.TRUE);
        }
    }

    @SubscribeEvent
    public void onBlockBreaking(BlockEvent.BreakEvent event) {
        DrillItem drillItem;
        boolean toReturn;
        Player player = event.getPlayer();
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof DrillItem && (toReturn = (drillItem = (DrillItem)item).onBreakBlock(stack, pos, player))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemEntity item = event.getItemEntity();
        if (item != null && item.isAlive()) {
            ItemStack stack = item.getItem();
            if (!stack.isEmpty()) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack invStack;
                    if (i != player.getInventory().selected && !(invStack = player.getInventory().getItem(i)).isEmpty() && invStack.getItem() instanceof Sack) {
                        boolean changed = false;
                        boolean isVoid = ((Sack)invStack.getItem()).isVoid;
                        FilterSettings filter = new FilterSettings(4, false, false, false, false);
                        filter.readFromNBT((HolderLookup.Provider)player.registryAccess(), new CompoundTag(), "Filter");
                        if (isVoid) {
                            if (filter.check(stack)) {
                                stack.setCount(0);
                                changed = true;
                            }
                        } else {
                            Optional<ItemStackHandlerAA> optHandler = SackManager.get().getHandler(invStack);
                            if (optHandler.isEmpty()) continue;
                            ItemStackHandlerAA inv = optHandler.get();
                            if (filter.check(stack)) {
                                for (int j = 0; j < inv.getSlots(); ++j) {
                                    ItemStack bagStack = inv.getStackInSlot(j);
                                    if (!bagStack.isEmpty()) {
                                        int maxTransfer;
                                        if (ItemUtil.canBeStacked(bagStack, stack) && (maxTransfer = Math.min(stack.getCount(), stack.getMaxStackSize() - bagStack.getCount())) > 0) {
                                            inv.setStackInSlot(j, StackUtil.grow(bagStack, maxTransfer));
                                            stack.shrink(maxTransfer);
                                            changed = true;
                                        }
                                    } else {
                                        inv.setStackInSlot(j, stack.copy());
                                        stack.setCount(0);
                                        changed = true;
                                    }
                                    if (stack.isEmpty()) break;
                                }
                            }
                        }
                        if (changed) {
                            event.setCanPickup(TriState.FALSE);
                        }
                    }
                    if (stack.isEmpty()) break;
                }
            }
            item.setItem(stack);
        }
    }

    @SubscribeEvent
    public void onEntityDropEvent(LivingDropsEvent event) {
        if (event.getEntity().level() != null && !event.getEntity().level().isClientSide && event.getSource().getEntity() instanceof Player && ConfigBoolValues.DO_SPIDER_DROPS.isEnabled() && event.getEntity() instanceof Spider && event.getEntity().level().random.nextInt(20) <= 1) {
            event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)Blocks.COBWEB, event.getEntity().level().random.nextInt(3) + 1)));
        }
    }

    @SubscribeEvent
    public void onLogInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player;
        if (!event.getEntity().level().isClientSide && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketHelperServer.syncPlayerData((Player)player2, true);
            ActuallyAdditions.LOGGER.info("Sending Player Data to player {} with UUID {}.", (Object)player2.getName(), (Object)player2.getUUID());
        }
    }

    @SubscribeEvent
    public void onCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
        PlayerData.PlayerSave save;
        String name;
        if (((Boolean)CommonConfig.Other.GIVE_BOOKLET_ON_FIRST_CRAFT.get()).booleanValue() && !event.getEntity().level().isClientSide && !event.getCrafting().isEmpty() && event.getCrafting().getItem() != ActuallyItems.ITEM_BOOKLET.get() && (name = BuiltInRegistries.ITEM.getKey((Object)event.getCrafting().getItem()).toString()) != null && name.toLowerCase(Locale.ROOT).contains("actuallyadditions") && (save = PlayerData.getDataFromPlayer(event.getEntity())) != null && !save.bookGottenAlready) {
            save.bookGottenAlready = true;
            WorldData.get(event.getEntity().getCommandSenderWorld()).setDirty();
            ItemEntity entityItem = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)ActuallyItems.ITEM_BOOKLET.get()));
            entityItem.setPickUpDelay(0);
            event.getEntity().level().addFreshEntity((Entity)entityItem);
        }
    }

    @SubscribeEvent
    public void onSmeltedEvent(PlayerEvent.ItemSmeltedEvent event) {
    }

    @SubscribeEvent
    public void onPickupEvent(ItemEntityPickupEvent.Pre event) {
    }

    @SubscribeEvent
    public void onAnvilEvent(AnvilUpdateEvent event) {
        if (!event.getLeft().isEmpty() && event.getLeft().getItem() instanceof ItemTag && event.getName() != null && !event.getName().isEmpty()) {
            event.setCost(0L);
            ResourceLocation tagLocation = ResourceLocation.tryParse((String)event.getName());
            if (tagLocation != null) {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tagLocation);
                Optional tag = BuiltInRegistries.ITEM.getTag(tagKey);
                if (tag.isPresent()) {
                    ItemStack stack = event.getLeft().copy();
                    stack.set(ActuallyComponents.ITEM_TAG, (Object)tagLocation);
                    event.setOutput(stack);
                } else {
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }
}

