/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.ellpeck.actuallyadditions.api.misc.IGoggles;
import de.ellpeck.actuallyadditions.mod.blocks.IHudDisplay;
import de.ellpeck.actuallyadditions.mod.config.ClientConfig;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import de.ellpeck.actuallyadditions.mod.inventory.gui.EnergyDisplay;
import de.ellpeck.actuallyadditions.mod.items.DrillItem;
import de.ellpeck.actuallyadditions.mod.items.ItemDrillUpgrade;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class ClientEvents {
    private static final Component ADVANCED_INFO_TEXT_PRE = Component.literal((String)"  -").withStyle(ChatFormatting.DARK_GRAY);
    private static final Component ADVANCED_INFO_HEADER_PRE = Component.literal((String)"  -").withStyle(ChatFormatting.GRAY);
    private static EnergyDisplay energyDisplay;
    private final Set<Entity> cachedGlowingEntities = new ConcurrentSet();

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            WorldData.clear();
        }
        if (mc.player != null) {
            this.renderEngineerEffect((Player)mc.player);
        }
    }

    private void renderEngineerEffect(Player player) {
        IGoggles goggles;
        Item item;
        ItemStack face = (ItemStack)player.getInventory().armor.get(3);
        if (player != null && !face.isEmpty() && (item = face.getItem()) instanceof IGoggles && (goggles = (IGoggles)item).displaySpectralMobs()) {
            double range = 8.0;
            AABB aabb = new AABB(player.getX() - range, player.getY() - range, player.getZ() - range, player.getX() + range, player.getY() + range, player.getZ() + range);
            List entities = player.level().getEntitiesOfClass(Entity.class, aabb);
            if (entities != null && !entities.isEmpty()) {
                this.cachedGlowingEntities.addAll(entities);
            }
            if (!this.cachedGlowingEntities.isEmpty()) {
                for (Entity entity : this.cachedGlowingEntities) {
                    if (!entity.isAlive() || entity.distanceToSqr(player.getX(), player.getY(), player.getZ()) > range * range) {
                        entity.setGlowingTag(false);
                        this.cachedGlowingEntities.remove(entity);
                        continue;
                    }
                    entity.setGlowingTag(true);
                }
            }
            return;
        }
        if (!this.cachedGlowingEntities.isEmpty()) {
            for (Entity entity : this.cachedGlowingEntities) {
                if (!entity.isAlive()) continue;
                entity.setGlowingTag(false);
            }
            this.cachedGlowingEntities.clear();
        }
    }

    @SubscribeEvent
    public void onTooltipEvent(ItemTooltipEvent event) {
    }

    @SubscribeEvent
    public void onGameOverlay(RenderGuiLayerEvent.Post event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (event.getName() == VanillaGuiLayers.CAMERA_OVERLAYS && minecraft.screen == null) {
            GuiGraphics guiGraphics = event.getGuiGraphics();
            LocalPlayer player = minecraft.player;
            if (player == null) {
                return;
            }
            HitResult posHit = minecraft.hitResult;
            Font font = minecraft.font;
            ItemStack stack = player.getMainHandItem();
            if (!stack.isEmpty() && stack.getItem() instanceof IHudDisplay) {
                ((IHudDisplay)stack.getItem()).getHud().displayHud(guiGraphics, minecraft, (Player)player, stack, posHit, minecraft.getWindow());
            }
            if (posHit != null && posHit.getType() == HitResult.Type.BLOCK) {
                TileEntityBase base;
                BlockHitResult rayCast = (BlockHitResult)posHit;
                Block blockHit = minecraft.level.getBlockState(rayCast.getBlockPos()).getBlock();
                BlockEntity tileHit = minecraft.level.getBlockEntity(rayCast.getBlockPos());
                if (blockHit instanceof IHudDisplay) {
                    ((IHudDisplay)blockHit).getHud().displayHud(guiGraphics, minecraft, (Player)player, stack, posHit, minecraft.getWindow());
                }
                if (tileHit instanceof TileEntityBase && (base = (TileEntityBase)tileHit).isRedstoneToggle()) {
                    MutableComponent component = Component.translatable((String)"info.actuallyadditions.redstoneMode").append(": ").append((Component)Component.translatable((String)("info.actuallyadditions.redstoneMode." + (base.isPulseMode ? "pulse" : "deactivation"))).withStyle(ChatFormatting.DARK_RED));
                    guiGraphics.drawString(font, (Component)component, (int)((float)minecraft.getWindow().getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)minecraft.getWindow().getGuiScaledHeight() / 2.0f + 5.0f), 0xFFFFFF);
                    MutableComponent expl = !stack.isEmpty() && stack.getItem() == CommonConfig.Other.redstoneConfigureItem ? Component.translatable((String)"info.actuallyadditions.redstoneMode.validItem").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"info.actuallyadditions.redstoneMode.invalidItem", (Object[])new Object[]{Component.translatable((String)CommonConfig.Other.redstoneConfigureItem.asItem().getDescriptionId()).getString()}).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
                    guiGraphics.drawString(font, (Component)expl, (int)((float)minecraft.getWindow().getGuiScaledWidth() / 2.0f + 5.0f), (int)((float)minecraft.getWindow().getGuiScaledHeight() / 2.0f + 15.0f), 0xFFFFFF);
                }
                if (tileHit instanceof IEnergyDisplay) {
                    IEnergyDisplay display = (IEnergyDisplay)tileHit;
                    if (!(((Boolean)ClientConfig.HIDE_ENERGY_OVERLAY.get()).booleanValue() || display.needsHoldShift() && !player.isShiftKeyDown())) {
                        if (energyDisplay == null) {
                            energyDisplay = new EnergyDisplay(0, 0, null);
                        }
                        energyDisplay.setData(2, minecraft.getWindow().getGuiScaledHeight() - 96, display.getEnergyStorage(), true, true);
                        PoseStack matrices = guiGraphics.pose();
                        matrices.pushPose();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        energyDisplay.draw(guiGraphics);
                        matrices.popPose();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (mc.player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof DrillItem) {
            DrillItem drillItem = (DrillItem)item;
            if (!player.isShiftKeyDown() && drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
                Level level = player.level();
                Vec3 vec3 = event.getCamera().getPosition();
                double d0 = vec3.x();
                double d1 = vec3.y();
                double d2 = vec3.z();
                BlockHitResult blockHitResult = event.getTarget();
                BlockPos targetPos = blockHitResult.getBlockPos();
                BlockState blockState = level.getBlockState(targetPos);
                VertexConsumer lineConsumer = event.getMultiBufferSource().getBuffer(RenderType.lines());
                if (stack.isCorrectToolForDrops(blockState)) {
                    int radius = 0;
                    if (drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.FIVE_BY_FIVE)) {
                        radius = 2;
                    } else if (drillItem.getHasUpgrade(stack, ItemDrillUpgrade.UpgradeType.THREE_BY_THREE)) {
                        radius = 1;
                    }
                    if (radius == 0) {
                        return;
                    }
                    List<BlockPos> coords = drillItem.gatherBreakingPositions(stack, radius, level, targetPos, blockHitResult.getDirection(), (Player)player);
                    for (BlockPos blockPos : coords) {
                        if (blockPos.equals((Object)targetPos)) continue;
                        AssetUtil.renderHitOutline(event.getPoseStack(), lineConsumer, (Entity)player, d0, d1, d2, level, blockPos, level.getBlockState(blockPos));
                    }
                }
            }
        }
    }
}

