/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class SolidFuelRecipe
implements Recipe<SingleRecipeInput> {
    public static String NAME = "solid_fuel";
    private Ingredient itemIngredient;
    private int burnTime;
    private int totalEnergy;

    public SolidFuelRecipe(Ingredient itemIngredient, int totalEnergy, int burnTime) {
        this.itemIngredient = itemIngredient;
        this.burnTime = burnTime;
        this.totalEnergy = totalEnergy;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public boolean matches(SingleRecipeInput pInv, Level pLevel) {
        return this.itemIngredient.test(pInv.getItem(0));
    }

    public boolean matches(ItemStack stack) {
        return this.itemIngredient.test(stack);
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack assemble(SingleRecipeInput pInv, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.SOLID_FUEL_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return ActuallyRecipes.Types.SOLID_FUEL.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidFuelRecipe> {
        private static final MapCodec<SolidFuelRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(recipe -> recipe.itemIngredient), (App)Codec.INT.fieldOf("total_energy").forGetter(recipe -> recipe.totalEnergy), (App)Codec.INT.fieldOf("burn_time").forGetter(recipe -> recipe.burnTime)).apply((Applicative)instance, SolidFuelRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SolidFuelRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SolidFuelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SolidFuelRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static SolidFuelRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            Ingredient itemIngredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            int totalEnergy = pBuffer.readInt();
            int burnTime = pBuffer.readInt();
            return new SolidFuelRecipe(itemIngredient, totalEnergy, burnTime);
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, SolidFuelRecipe pRecipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.itemIngredient);
            pBuffer.writeInt(pRecipe.totalEnergy);
            pBuffer.writeInt(pRecipe.burnTime);
        }
    }
}

