/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.serialization.MapCodec;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class RecipeKeepDataShapeless
extends ShapelessRecipe {
    public static String NAME = "copy_nbt_shapeless";

    public RecipeKeepDataShapeless(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
    }

    public RecipeKeepDataShapeless(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), recipe.getIngredients());
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.KEEP_DATA_SHAPELESS_RECIPE.get();
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider provider) {
        ItemStack result = super.assemble(pContainer, provider);
        TargetNBTIngredient donorIngredient = null;
        ItemStack datasource = ItemStack.EMPTY;
        NonNullList ingredients = this.getIngredients();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient.getCustomIngredient() instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient.getCustomIngredient();
            break;
        }
        if (donorIngredient != null && !pContainer.isEmpty()) {
            for (int i = 0; i < pContainer.size(); ++i) {
                ItemStack item = pContainer.getItem(i);
                if (item.isEmpty() || !donorIngredient.test(item)) continue;
                datasource = item;
                break;
            }
        }
        if (datasource.isEmpty() || datasource.getComponents().isEmpty()) {
            ActuallyAdditions.LOGGER.info("AA.KeepDataShapeless missing TargetNBTIngredient");
            return ItemStack.EMPTY;
        }
        result.applyComponents(datasource.getComponents());
        return result;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeKeepDataShapeless> {
        public static final MapCodec<RecipeKeepDataShapeless> CODEC = ShapelessRecipe.Serializer.CODEC.xmap(RecipeKeepDataShapeless::new, $ -> $);
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeKeepDataShapeless> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RecipeKeepDataShapeless> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeKeepDataShapeless> streamCodec() {
            return STREAM_CODEC;
        }

        public static RecipeKeepDataShapeless fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            return new RecipeKeepDataShapeless((ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.streamCodec().decode((Object)pBuffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, RecipeKeepDataShapeless pRecipe) {
            try {
                RecipeSerializer.SHAPELESS_RECIPE.streamCodec().encode((Object)pBuffer, (Object)pRecipe);
            }
            catch (Exception e) {
                ActuallyAdditions.LOGGER.info("Failed to serialize {} Recipe to packet: {}", (Object)NAME, (Object)e.getMessage());
                throw e;
            }
        }
    }
}

