/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.crafting;

import com.mojang.serialization.MapCodec;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.crafting.ActuallyRecipes;
import de.ellpeck.actuallyadditions.mod.crafting.TargetNBTIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class RecipeKeepDataShaped
extends ShapedRecipe {
    public static String NAME = "copy_nbt";

    public RecipeKeepDataShaped(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem(null));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack craftingResult = super.assemble(inv, registries);
        TargetNBTIngredient donorIngredient = null;
        ItemStack datasource = ItemStack.EMPTY;
        NonNullList ingredients = this.getIngredients();
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient.getCustomIngredient() instanceof TargetNBTIngredient)) continue;
            donorIngredient = (TargetNBTIngredient)ingredient.getCustomIngredient();
            break;
        }
        if (donorIngredient != null && !inv.isEmpty()) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack item = inv.getItem(i);
                if (item.isEmpty() || !donorIngredient.test(item)) continue;
                datasource = item;
                break;
            }
        }
        if (!datasource.isEmpty() && !datasource.getComponents().isEmpty()) {
            craftingResult.applyComponents(datasource.getComponents());
        }
        return craftingResult;
    }

    public RecipeSerializer<?> getSerializer() {
        return ActuallyRecipes.KEEP_DATA_SHAPED_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeKeepDataShaped> {
        private static final MapCodec<RecipeKeepDataShaped> CODEC = ShapedRecipe.Serializer.CODEC.xmap(RecipeKeepDataShaped::new, $ -> $);
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeKeepDataShaped> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<RecipeKeepDataShaped> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeKeepDataShaped> streamCodec() {
            return STREAM_CODEC;
        }

        public static RecipeKeepDataShaped fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new RecipeKeepDataShaped((ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, RecipeKeepDataShaped recipe) {
            try {
                RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            }
            catch (Exception exception) {
                ActuallyAdditions.LOGGER.info("Error writing {} Recipe to packet: ", (Object)NAME, (Object)exception);
                throw exception;
            }
        }
    }
}

