/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.base;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BlockPlant
extends CropBlock {
    public Supplier<Item> seedItem;

    public BlockPlant(Supplier<Item> seedItem) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).pushReaction(PushReaction.DESTROY).noCollission().randomTicks().instabreak().sound(SoundType.CROP));
        this.seedItem = seedItem;
    }

    @Deprecated
    public void doStuff(Supplier<Item> seedItem, Item returnItem, int returnMeta) {
        this.seedItem = seedItem;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack pStack, @Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult pHitResult) {
        if (this.getAge(state) < 7) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!world.isClientSide) {
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null);
            boolean deductedSeedSize = false;
            for (ItemStack drop : drops) {
                if (drop.isEmpty()) continue;
                if (drop.getItem() == this.seedItem.get() && !deductedSeedSize) {
                    drop.shrink(1);
                    deductedSeedSize = true;
                }
                if (drop.isEmpty()) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
            }
            world.setBlockAndUpdate(pos, (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
        }
        return super.useItemOn(pStack, state, world, pos, player, hand, pHitResult);
    }

    @Nonnull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)this.seedItem.get();
    }
}

