/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn.command;

import com.frikinjay.letmedespawn.LetMeDespawn;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;

public class LetMeDespawnCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"letmedespawn").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"add").then(Commands.argument((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestMobNames).executes(LetMeDespawnCommands::addMob)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestConfiguredMobNames).executes(LetMeDespawnCommands::removeMob))));
    }

    private static CompletableFuture<Suggestions> suggestMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
            if (entityType.getCategory().equals((Object)MobCategory.MONSTER)) {
                builder.suggest(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
            }
        });
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestConfiguredMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LetMeDespawn.config.getMobNames().stream().filter(mobName -> mobName.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int addMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Mob '" + mobName + "' is already in the configuration.")).withStyle(ChatFormatting.RED), false);
        } else {
            LetMeDespawn.config.addMobName(mobName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Added '" + mobName + "' to LetMeDespawn configuration.")).withStyle(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int removeMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            LetMeDespawn.config.removeMobName(mobName);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Removed '" + mobName + "' from LetMeDespawn configuration.")).withStyle(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Mob '" + mobName + "' is not in the configuration.")).withStyle(ChatFormatting.RED), false);
        }
        return 1;
    }
}

