/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import snownee.jade.gui.config.value.OptionValue;

public class SliderOptionValue
extends OptionValue<Float> {
    private final Slider slider;
    private float min;
    private float max;
    private FloatUnaryOperator aligner;

    public SliderOptionValue(String optionName, Supplier<Float> getter, Consumer<Float> setter, float min, float max, FloatUnaryOperator aligner) {
        super(optionName, getter, setter);
        this.value = getter.get();
        this.min = min;
        this.max = max;
        this.aligner = aligner;
        this.slider = new Slider(this, 0, 0, 100, 20, this.getTitle());
        this.updateValue();
        this.addWidget((AbstractWidget)this.slider, 0);
    }

    @Override
    public void setValue(Float value) {
        this.slider.setValue(value.floatValue(), true);
    }

    @Override
    public void updateValue() {
        this.value = this.getter.get();
        this.slider.setValue(((Float)this.value).floatValue(), false);
    }

    public static class Slider
    extends AbstractSliderButton {
        private static final DecimalFormat fmt = new DecimalFormat("##.##");
        private final SliderOptionValue parent;

        public Slider(SliderOptionValue parent, int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)parent.value).floatValue(), parent.min, parent.max));
            this.parent = parent;
            this.updateMessage();
        }

        public static double fromScaled(float f, float min, float max) {
            return Mth.clamp((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        public float toScaled() {
            float f = this.parent.aligner.apply(this.parent.min + (this.parent.max - this.parent.min) * (float)this.value);
            String s = fmt.format(f);
            try {
                return fmt.parse(s).floatValue();
            }
            catch (ParseException e) {
                return f;
            }
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)fmt.format(this.toScaled())));
        }

        protected void applyValue() {
            float scaled = this.toScaled();
            if (((Float)this.parent.value).floatValue() != scaled) {
                this.parent.value = Float.valueOf(scaled);
                this.parent.save();
            }
        }

        private void setValue(float value, boolean applyValue) {
            if (value != this.toScaled()) {
                this.value = Slider.fromScaled(value, this.parent.min, this.parent.max);
                if (applyValue) {
                    this.applyValue();
                }
            }
            this.updateMessage();
        }

        protected MutableComponent createNarrationMessage() {
            return CommonComponents.joinForNarration((Component[])new Component[]{this.parent.getTitle(), super.createNarrationMessage()});
        }
    }
}

