/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.mixin.client;

import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xfacthd.framedblocks.client.util.FramedClientUtils;

@Debug(export=true)
@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private GraphicsStatus framedblocks$lastGraphicsMode;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void framedblocks$captureInitialGraphicsMode(Minecraft mc, EntityRenderDispatcher entityRenderDispatcher, BlockEntityRenderDispatcher blockEntityRenderDispatcher, RenderBuffers buffers, CallbackInfo ci) {
        this.framedblocks$lastGraphicsMode = (GraphicsStatus)mc.options.graphicsMode().get();
    }

    @Inject(method={"allChanged"}, at={@At(value="HEAD")})
    private void framedblocks$handleRedrawOnGraphicsModeChange(CallbackInfo ci) {
        GraphicsStatus graphicsMode = (GraphicsStatus)this.minecraft.options.graphicsMode().get();
        if (graphicsMode != this.framedblocks$lastGraphicsMode) {
            this.framedblocks$lastGraphicsMode = graphicsMode;
            FramedClientUtils.clearModelCaches();
        }
    }
}

