/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;

public abstract class FramedSpecialDoubleBlockItem
extends BlockItem {
    public FramedSpecialDoubleBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        BlockState newState;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState originalState = level.getBlockState(pos);
        if (ctx.canPlace() && originalState.is(this.getBlock()) && (newState = this.getReplacementState(ctx, originalState)) != null) {
            if (!level.isClientSide()) {
                BlockEntity blockEntity;
                boolean writeToCamoTwo = this.shouldWriteToCamoTwo(ctx, originalState);
                CamoList camos = (CamoList)ctx.getItemInHand().get(FBContent.DC_TYPE_CAMO_LIST);
                Utils.wrapInStateCopy((LevelAccessor)level, pos, ctx.getPlayer(), ctx.getItemInHand(), writeToCamoTwo, true, () -> level.setBlockAndUpdate(pos, newState));
                CamoContainer camo = EmptyCamoContainer.EMPTY;
                if (camos != null && !camos.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof FramedDoubleBlockEntity) {
                    FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
                    camo = camos.getCamo(0);
                    be.setCamo(camo, !writeToCamoTwo);
                }
                SoundType sound = ((CamoContent)camo.getContent()).getSoundType();
                level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.place(ctx);
    }

    @Nullable
    protected abstract BlockState getReplacementState(BlockPlaceContext var1, BlockState var2);

    protected abstract boolean shouldWriteToCamoTwo(BlockPlaceContext var1, BlockState var2);
}

