/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.elements;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.elements.ExtendedElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.RowElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.ElementCategory;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.BookRoot;

public final class GridElementBuilder
extends ExtendedElementBuilder<GridElementBuilder> {
    private final List<RowElementBuilder> rows = new ArrayList<RowElementBuilder>();
    private String width = null;
    private String height = null;

    public GridElementBuilder() {
        super(ElementCategory.PAGE, "grid");
    }

    public GridElementBuilder widthAbs(int width) {
        this.width = Integer.toString(width);
        return this;
    }

    public GridElementBuilder widthRel(int width) {
        this.width = width + "%";
        return this;
    }

    public GridElementBuilder heightAbs(int height) {
        this.height = Integer.toString(height);
        return this;
    }

    public GridElementBuilder heightRel(int height) {
        this.height = height + "%";
        return this;
    }

    public GridElementBuilder row(RowElementBuilder row) {
        this.rows.add(row);
        return this;
    }

    @Override
    public void validate(BookRoot book) {
        super.validate(book);
        if (!this.rows.isEmpty()) {
            int colCount = this.rows.get(0).getColumnCount();
            this.rows.forEach(row -> {
                if (row.getColumnCount() != colCount) {
                    throw new IllegalStateException("All rows in a grid must have the same number of columns!");
                }
            });
        }
    }

    @Override
    protected void printInternal(Document doc, Element elementElem) {
        GridElementBuilder.printNullableAttr(elementElem, "width", this.width);
        GridElementBuilder.printNullableAttr(elementElem, "height", this.height);
        this.rows.forEach(row -> row.print(doc, elementElem));
    }
}

