/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.QuarterTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.ThreewayCornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredPanelSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.CheckeredSlabSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.InnerCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.InnerThreewayCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ThreewayCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
public final class CornerSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> CornerSlopeEdgeSkipPredicate.testAgainstSlabEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> CornerSlopeEdgeSkipPredicate.testAgainstSlabCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> CornerSlopeEdgeSkipPredicate.testAgainstCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_STAIRS -> CornerSlopeEdgeSkipPredicate.testAgainstStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> CornerSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> CornerSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> CornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> CornerSlopeEdgeSkipPredicate.testAgainstSmallCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> CornerSlopeEdgeSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> CornerSlopeEdgeSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> CornerSlopeEdgeSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> CornerSlopeEdgeSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> CornerSlopeEdgeSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> CornerSlopeEdgeSkipPredicate.testAgainstCheckeredSlabSegment(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> CornerSlopeEdgeSkipPredicate.testAgainstCheckeredPanelSegment(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> CornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> CornerSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, type, alt, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return CornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(CornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(CornerSlopeEdgeSkipPredicate.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return CornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return CornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(ElevatedCornerSlopeEdgeSkipPredicate.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return CornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(ThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return CornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(CheckeredSlabSegmentSkipPredicate.getCornerDir(adjTop, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(CheckeredPanelSegmentSkipPredicate.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(ThreewayCornerPillarSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return CornerSlopeEdgeSkipPredicate.getCornerDir(dir, type, alt, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    public static QuarterTriangleDir getTriDir(Direction dir, CornerType type, boolean alt, Direction side) {
        if (type.isHorizontal()) {
            Direction backTwo;
            Direction backOne = type.isTop() ? Direction.UP : Direction.DOWN;
            Direction direction = backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
            if (side == backOne) {
                return QuarterTriangleDir.fromDirections(dir, backTwo, alt);
            }
            if (side == backTwo) {
                return QuarterTriangleDir.fromDirections(dir, backOne, alt);
            }
        } else {
            Direction bottom;
            Direction direction = bottom = type.isTop() ? Direction.UP : Direction.DOWN;
            if (side == dir) {
                return QuarterTriangleDir.fromDirections(dir.getCounterClockWise(), bottom, alt);
            }
            if (side == dir.getCounterClockWise()) {
                return QuarterTriangleDir.fromDirections(dir, bottom, alt);
            }
        }
        return QuarterTriangleDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, CornerType type, boolean alt, Direction side) {
        if (!alt) {
            if (type.isHorizontal()) {
                if (side == dir) {
                    return CornerDir.fromDirections(dir, type.isTop() ? Direction.UP : Direction.DOWN, type.isRight() ? dir.getClockWise() : dir.getCounterClockWise());
                }
            } else {
                Direction bottom;
                Direction direction = bottom = type.isTop() ? Direction.UP : Direction.DOWN;
                if (side == bottom) {
                    return CornerDir.fromDirections(bottom, dir, dir.getCounterClockWise());
                }
            }
        }
        return CornerDir.NULL;
    }
}

