/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_FENCE})
public final class FenceSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_FENCE -> FenceSkipPredicate.testAgainstFence(state, adjState, side);
                case BlockType.FRAMED_FENCE_GATE -> FenceSkipPredicate.testAgainstFenceGate(state, adjState, side);
                case BlockType.FRAMED_POST -> FenceSkipPredicate.testAgainstPost(adjState, side);
                case BlockType.FRAMED_LATTICE_BLOCK -> FenceSkipPredicate.testAgainstLattice(adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstFence(BlockState state, BlockState adjState, Direction side) {
        return Utils.isY(side) || FenceSkipPredicate.hasFenceArm(state, side) && FenceSkipPredicate.hasFenceArm(adjState, side.getOpposite());
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE_GATE}, oneWay=true)
    private static boolean testAgainstFenceGate(BlockState state, BlockState adjState, Direction side) {
        if (!Utils.isY(side) && FenceSkipPredicate.hasFenceArm(state, side)) {
            Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return adjDir.getClockWise().getAxis() == side.getAxis();
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(BlockState adjState, Direction side) {
        return Utils.isY(side) && adjState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(BlockState adjState, Direction side) {
        return Utils.isY(side) && (Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS) != false;
    }

    private static boolean hasFenceArm(BlockState state, Direction side) {
        return switch (side) {
            case Direction.NORTH -> (Boolean)state.getValue((Property)FenceBlock.NORTH);
            case Direction.EAST -> (Boolean)state.getValue((Property)FenceBlock.EAST);
            case Direction.SOUTH -> (Boolean)state.getValue((Property)FenceBlock.SOUTH);
            case Direction.WEST -> (Boolean)state.getValue((Property)FenceBlock.WEST);
            default -> throw new IllegalArgumentException("Invalid fence arm side: " + String.valueOf(side));
        };
    }
}

