/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.common.FBContent;

public final class CamoApplicationRecipe
extends CustomRecipe {
    private final Ingredient copyTool;

    public CamoApplicationRecipe(CraftingBookCategory category, Ingredient copyTool) {
        super(category);
        this.copyTool = copyTool;
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean doubleBlock;
        BlockItem item;
        if (input.width() != 2 || input.height() != 2 || !this.copyTool.test(input.getItem(1, 0))) {
            return false;
        }
        ItemStack blockStack = input.getItem(0, 0);
        Item item2 = blockStack.getItem();
        if (!(item2 instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).getBlock()) instanceof IFramedBlock)) {
            return false;
        }
        IFramedBlock block = (IFramedBlock)item2;
        ItemStack camoOneStack = input.getItem(0, 1);
        boolean camoOne = false;
        if (!camoOneStack.isEmpty()) {
            CamoContainerFactory<?> factoryOne = CamoContainerHelper.findCamoFactory(camoOneStack);
            if (factoryOne == null || !factoryOne.canApplyInCraftingRecipe(camoOneStack)) {
                return false;
            }
            camoOne = true;
        }
        ItemStack camoTwoStack = input.getItem(1, 1);
        boolean camoTwo = false;
        if (!camoTwoStack.isEmpty()) {
            CamoContainerFactory<?> factoryTwo = CamoContainerHelper.findCamoFactory(camoTwoStack);
            if (factoryTwo == null || !factoryTwo.canApplyInCraftingRecipe(camoTwoStack)) {
                return false;
            }
            camoTwo = true;
        }
        return (doubleBlock = block.getBlockType().consumesTwoCamosInCamoApplicationRecipe()) ? camoOne || camoTwo : camoOne ^ camoTwo;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        BlockItem item;
        if (input.width() != 2 || input.height() != 2 || !this.copyTool.test(input.getItem(1, 0))) {
            return ItemStack.EMPTY;
        }
        ItemStack blockStack = input.getItem(0, 0);
        Item item2 = blockStack.getItem();
        if (!(item2 instanceof BlockItem) || !((item2 = (item = (BlockItem)item2).getBlock()) instanceof IFramedBlock)) {
            return ItemStack.EMPTY;
        }
        IFramedBlock block = (IFramedBlock)item2;
        ArrayList camos = new ArrayList(2);
        ItemStack camoOneStack = input.getItem(0, 1);
        if (!camoOneStack.isEmpty()) {
            CamoContainerFactory<?> factoryOne = CamoContainerHelper.findCamoFactory(camoOneStack);
            if (factoryOne == null || !factoryOne.canApplyInCraftingRecipe(camoOneStack)) {
                return ItemStack.EMPTY;
            }
            camos.add((CamoContainer<?, ?>)factoryOne.applyCamoInCraftingRecipe(camoOneStack));
        } else if (block.getBlockType().consumesTwoCamosInCamoApplicationRecipe()) {
            camos.add(EmptyCamoContainer.EMPTY);
        }
        ItemStack camoTwoStack = input.getItem(1, 1);
        if (!camoTwoStack.isEmpty()) {
            CamoContainerFactory<?> factoryTwo = CamoContainerHelper.findCamoFactory(camoTwoStack);
            if (factoryTwo == null || !factoryTwo.canApplyInCraftingRecipe(camoTwoStack)) {
                return ItemStack.EMPTY;
            }
            camos.add((CamoContainer<?, ?>)factoryTwo.applyCamoInCraftingRecipe(camoTwoStack));
        }
        ItemStack result = blockStack.copyWithCount(1);
        result.set(FBContent.DC_TYPE_CAMO_LIST, (Object)CamoList.of(camos));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        ItemStack camoTwoStack;
        ItemStack camoOneStack;
        NonNullList remaining = super.getRemainingItems((RecipeInput)input);
        if (((ItemStack)remaining.get(1)).isEmpty()) {
            remaining.set(1, (Object)input.getItem(1, 0).copy());
        }
        if (!(camoOneStack = input.getItem(0, 1)).isEmpty()) {
            CamoContainerFactory<?> factoryOne = CamoContainerHelper.findCamoFactory(camoOneStack);
            remaining.set(2, (Object)Objects.requireNonNull(factoryOne).getCraftingRemainder(camoOneStack));
        }
        if (!(camoTwoStack = input.getItem(1, 1)).isEmpty()) {
            CamoContainerFactory<?> factoryTwo = CamoContainerHelper.findCamoFactory(camoTwoStack);
            remaining.set(3, (Object)Objects.requireNonNull(factoryTwo).getCraftingRemainder(camoTwoStack));
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public Ingredient getCopyTool() {
        return this.copyTool;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FBContent.RECIPE_SERIALIZER_APPLY_CAMO.value();
    }
}

